/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44CardReceive.h"
#include "JT44Defs.h"
#include "JT44App.h"

#include "common/SoundFile.h"

#include <wx/datetime.h>
#include <wx/filename.h>
#include <wx/debug.h>
#include <wx/log.h>

CJT44CardReceive::CJT44CardReceive(const wxString& name, ISoundDev* soundDev, EWho who) :
CJT44Receive(name, who),
m_soundDev(soundDev)
{
	wxASSERT(m_soundDev != NULL);
}

CJT44CardReceive::~CJT44CardReceive()
{
}

bool CJT44CardReceive::getEndTime()
{
	wxDateTime now = wxDateTime::UNow();

	if (now.GetSecond() != 29 && now.GetSecond() != 59)
		return false;

	return (now.GetMillisecond() > 700);
}

void CJT44CardReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openRead();
}

void CJT44CardReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
}

void CJT44CardReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);

	if (isRecording()) {
		wxString pathAudio, pathText;
		::wxGetApp().getPaths(pathAudio, pathText);

		wxFileName fileName(pathAudio, id, wxT("wav"));

		CSoundFile* file = new CSoundFile(fileName.GetFullPath(), JT44_SAMPLE_RATE, 8);
		file->openWrite();

		file->write(audioData, length);

		file->close();

		delete file;
	}
}

wxString CJT44CardReceive::createId()
{
	wxDateTime now = wxDateTime::Now();

	return now.Format(wxT("%Y%m%d_%H%M%S"), wxDateTime::UTC);
}

void CJT44CardReceive::error(const wxString& text)
{
	::wxLogError(wxT("%s: %s"), getName().c_str(), text.c_str());

	::wxGetApp().error(text);
}
