/*
 *  Xeukleides  version 0.9.0
 *  Copyright (c) Christian Obrecht 2000-2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

%{

#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "parser.tab.h"

#define NORMAL_MODE 0
#define TRACE_MODE 1
#define STRING_MODE 2
#define COMMENT_MODE 3

#undef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 65536

int warning(char *);

extern int lineno, file_length, cursor, assign_ind, starting, inputmode, bracepos, loopcount, offset;

extern char * buffer, * start;

assignrec assign_table[52];

int pos, len, lexmode=0, lexcount, lexlno;

char* lexpos;

symrec *sym_table = NULL;

symrec *putsym (char *sym_name)
{
  symrec *ptr;
  ptr = (symrec *)malloc(sizeof(symrec));
  ptr->name = (char *) malloc (strlen (sym_name) + 1);
  strcpy (ptr->name, sym_name);
  ptr->type = VARIABLE;
  ptr->next = sym_table;
  sym_table = ptr;
  return ptr;
}

symrec *getsym (char *sym_name)
{
  symrec *ptr;
  for (ptr = sym_table; ptr != NULL; ptr = ptr->next)
    if (strcmp (ptr->name, sym_name) == 0)
      return ptr;
  return NULL;
}

void clearsym(void)
{
  symrec *ptr, *prev;
  ptr = sym_table;
  while (ptr != NULL) {
    free(ptr->name);
    prev = ptr;
    ptr = ptr->next;
    free(prev);
  }
  sym_table = NULL;
}

saverec *save_table = NULL;

void save(void * s)
{
  saverec *ptr;
  ptr = (saverec *)malloc(sizeof(saverec));
  ptr->s = s;
  ptr->next = save_table;
  save_table = ptr;
}

void clearsave(void)
{
  saverec *ptr, *prev;
  ptr = save_table;
  while (ptr != NULL) {
    free(ptr->s);
    prev = ptr;
    ptr = ptr->next;
    free(prev);
  }
  save_table = NULL;
}

void clear(void)
{
  clearsym();
  clearsave();
}

int yywrap(void)
{
  return 1;
}

#undef YY_INPUT
#define YY_INPUT(buf,result,max) (result = char_input(buf,max))

int char_input(char *buf, int max)
{
  int n;
  
  n = 0;

  while (buffer[cursor] != '\0' && n < max) {
    buf[n] = buffer[cursor];
    switch (buffer[cursor]) {
      case '%':
	if (inputmode != STRING_MODE) inputmode = COMMENT_MODE;
	break;
      case '\n':
	if (inputmode == STRING_MODE || inputmode == COMMENT_MODE)
	  inputmode = NORMAL_MODE;
	break;
      case '"':
	if (inputmode == NORMAL_MODE) inputmode = STRING_MODE;
	else inputmode = NORMAL_MODE;
	break;
      case '{':
        if (inputmode == NORMAL_MODE) {
	  bracepos=cursor-1;
	  loopcount=TRACE_SIZE;
	  inputmode=TRACE_MODE;
	}
	break;
      case '}':
	if (inputmode == TRACE_MODE) {
          if (--loopcount)
            cursor=bracepos;
          else
            inputmode=NORMAL_MODE;
        }
    };
    cursor++; n++;
  }

  return n;
}

%}

%%

[\t ]+                                                                                  /* Ignore whitespace */
				  
%.*\n                           { lineno++; }                                           /* Comments */
				  
%.*				{ return '\n'; }

(([0-9]+)|([0-9]*\.[0-9]+))	{                                                       /* Numbers */
				  yylval.number = atof(yytext);
				  return NUMBER;
				}

\"[^\"\n]*[\"\n]                {                                                       /* Strings */
				  int n,m;
				  if (yytext[yyleng-1] != '"') {
				    warning("Unterminated character string");
				    lineno++;
				  }
				  yylval.string = (char*)malloc(yyleng-1);
				  n = 1; m = 0;
				  while (n < yyleng-1) {
				    if (yytext[n] != '$') {
				      yylval.string[m++] = yytext[n];
				    };
				    n++;
				  }
				  yylval.string[m] = '\0';
				  return STRING;
				}

point                           { return POINT; }                                       /* Reserved words */

vector                          { return VECTOR; }

line                            { return LINE; }

segment                         { return SEGMENT; }

circle                          { return CIRCLE; }

conic				{ return CONIC; }

parabola			{ return PARABOLA; }

ellipse				{ return ELLIPSE; }

hyperbola			{ return HYPERBOLA; }

translation                     { return TRANSLATION; }

reflection                      { return REFLECTION; }

rotation                        { return ROTATION; }

projection                      { return PROJECTION; }

homothecy                       { return HOMOTHECY; }

intersection                    { return INTERSECTION; }

parallel                        { return PARALLEL; }

perpendicular                   { return PERPENDICULAR; }

midpoint                        { return MIDPOINT; }

begin                           { return TOKBEGIN; }

end                             { return END; }

center                          { return CENTER; }

vertices			{ return VERTICES; }

foci				{ return FOCI; }

triangle                        { return TRIANGLE; }

equilateral                     { return EQUILATERAL; }

isosceles                       { return ISOSCELES; }

right                           { return RIGHT; }

barycenter                      { return BARYCENTER; }

median                          { return MEDIAN; }

altitude                        { return ALTITUDE; }

orthocenter                     { return ORTHOCENTER; }

bisector                        { return BISECTOR; }

incircle                        { return INCIRCLE; }

parallelogram                   { return PARALLELOGRAM; }

rectangle                       { return RECTANGLE; }

square                          { return SQUARE; }

pentagon			{ return PENTAGON; }

hexagon                         { return HEXAGON; }

abscissa                        { return ABSCISSA; }

ordinate                        { return ORDINATE; }

length                          { return LENGTH; }

distance			{ return DISTANCE; }

angle                           { return ANGLE; }

arg				{ return ARGUMENT; }

radius                          { return RADIUS; }

major				{ return MAJOR; }

minor				{ return MINOR; }

eccentricity			{ return ECCENTRICITY; }

height				{ return HEIGHT; }

exp				{ return EXP; }

ln 				{ return LN; }

pi				{ return TOKPI; }

sin                             { return SIN; }

cos                             { return COS; }

tan                             { return TAN; }

asin                            { return ASIN; }

acos                            { return ACOS; }

atan                            { return ATAN; }

deg				{ return TOKDEG; }

rad				{ return TOKRAD; }

abs				{ return TOKABS; }

sqrt                            { return SQRT; }

frame				{ return FRAME; }

color				{ return COLOR; }

black				{ return BLACK; }

darkgray			{ return DARKGRAY; }

gray				{ return GRAY; }

lightgray			{ return LIGHTGRAY; }

white				{ return WHITE; }

red				{ return RED; }

green				{ return GREEN; }

blue				{ return BLUE; }

cyan				{ return CYAN; }

magenta				{ return MAGENTA; }

yellow				{ return YELLOW; }

thickness			{ return THICKNESS; }

tricks				{ return TRICKS; }

font				{ return FONT; }

draw				{ return DRAW; }

mark				{ return MARK; }

dot				{ return DOT; }

box				{ return BOX; }

cross				{ return CROSS; }

plus				{ return PLUS; }

noarrow				{ return NOARROW; }

arrow				{ return ARROW; }

backarrow			{ return BACKARROW; }

doublearrow			{ return DOUBLEARROW; }

entire				{ return ENTIRE;}

halfline			{ return HALFLINE; }

backhalfline			{ return BACKHALFLINE; }

style				{ return STYLE; }

full				{ return FULL; }

dotted                          { return DOTTED; }

dashed                          { return DASHED; }

simple				{ return SIMPLE; }

double				{ return DOUBLE; }

triple				{ return TRIPLE; }

dash				{ return DASH; }

interactive			{ 
				  if (starting) {
				    if (assign_ind < 51) {
				      assign_ind++;
				      pos = 11+(int)(yytext-start)-offset%YY_READ_BUF_SIZE;
				      while (buffer[pos] != '(' && pos < file_length) pos++;
				      assign_table[assign_ind].pos = pos+1; len = 0;
				      while (buffer[pos+len] != ',' && pos+len < file_length) len++;
				      assign_table[assign_ind].len = len-1;
				    }
				    else warning("Too many interactive assignments\n");
				  }
				  return INTERACTIVE;
				}
				

up				{ return UP; }

trace				{ return TRACE; }

[a-zA-Z][a-zA-Z0-9]*            {                                                       /* Variables */
				  symrec *s;
				  s = getsym (yytext);
				  if (s == NULL) 
				    s = putsym (yytext); 
				  yylval.ptr = s;
				  switch (s->type)
				  {
				    case NUMBER         : return NUMBER_VARIABLE;
				    case POINT          : return POINT_VARIABLE;
				    case VECTOR         : return VECTOR_VARIABLE;
				    case LINE           : return LINE_VARIABLE;
				    case SEGMENT        : return SEGMENT_VARIABLE;
				    case CIRCLE         : return CIRCLE_VARIABLE;
				    case CONIC          : return CONIC_VARIABLE;
				    case INTERACTIVE	: return INTERACTIVE_VARIABLE;
				    case VARIABLE       : return VARIABLE;
				  }
				}

; 				{ return '\n'; }

"{"				{ 
  				  if (lexmode == NORMAL_MODE) {
	  			    lexcount = TRACE_SIZE;
				    lexpos = yytext;
				    lexlno = lineno;
	                            lexmode = TRACE_MODE;
	                          }
				  return '\n';
				}

"}"				{ 
				  if (lexcount==TRACE_SIZE) {
				    offset += (TRACE_SIZE-1)*((int)(yytext-lexpos)+1);
				    lineno -= (TRACE_SIZE-1)*(lineno-lexlno);
				  }
				  if (--lexcount == 0)
          			    lexmode=NORMAL_MODE;
				  return '}';
				}

\n				{ lineno++; return '\n'; }                              /* New line */

.                               { return yytext[0]; }                                   /* Anything else */
%%

