dnl Checks for the --with-faces option on ./configure, if given it sets the 
dnl FACES_CFLAGS and FACES_LIBS accordingly.

AC_DEFUN([FACES], [
AC_MSG_CHECKING(whether to include faces support)
AC_ARG_WITH(faces, [  --with-faces         Compile with faces library],
	AC_MSG_RESULT(yes)
	FACES_CFLAGS="-DWITH_FACES -I../compface"
	FACES_LIBS="-L../compface -L../compface/.libs -lface"
	cv_faces="yes"
,
	AC_MSG_RESULT(no)
	FACES_CFLAGS=""
	FACES_LIBS=""
	cv_faces="no"
)
AC_SUBST(FACES_CFLAGS)
AC_SUBST(FACES_LIBS)
AM_CONDITIONAL(BUILD_FACE, test x$cv_faces = xyes)
])
