dnl
dnl MOZILLA_INIT ()
dnl

AC_DEFUN([MOZILLA_INIT],[
	AC_SUBST(MOZ_CONFIG_LIBS)
	AC_SUBST(MOZ_CONFIG_CFLAGS)

	AC_ARG_WITH(mozilla,
	[  --with-mozilla            Specify prefix for Mozilla files],[
		if test x$withval = xyes; then
			:
        	else
	    		if test "x$withval" = xno; then
				:
	    		else
	    			LDFLAGS="$LDFLAGS -L$withval/lib"
	    			CFLAGS="$CFLAGS -I$withval/include"
	    			mozilla_prefix=$withval
	    		fi
  		fi
	])

	AC_ARG_WITH(mozilla-includes,
	[  --with-mozilla-includes   Specify location of Mozilla headers],[
	CFLAGS="$CFLAGS -I$withval"
	])

	AC_ARG_WITH(mozilla-libs,
	[  --with-mozilla-libs       Specify location of Mozilla libs],[
	LDFLAGS="$LDFLAGS -L$withval"
	mozilla_prefix=$withval
	])

	AC_ARG_WITH(mozilla-config,
	[  --with-mozilla-config   Specify location of Mozilla config script],[
	mozilla_conf=$withval
	])

	dnl Add directories to path when looking for MOZ_CONFIG
	if test x$mozilla_conf != x
	then
		config_path_test=$mozilla_conf
	else
		config_path_test=$mozilla_prefix/bin
	fi
	config_path_test=$config_path_test:/usr/local/lib/mozilla/bin
	config_path_test=$config_path_test:/usr/local/lib/mozilla
	config_path_test=$config_path_test:/usr/lib/mozilla/bin
	config_path_test=$config_path_test:/usr/lib/mozilla

	AC_PATH_PROG(MOZ_CONFIG,mozilla-config,no,$PATH:$config_path_test)
	if test "$MOZ_CONFIG" = "no"; then
	    AC_MSG_ERROR(Could not find the mozilla-config script needed to find mozilla components on the system)
	else
	    AC_MSG_CHECKING(if $MOZ_CONFIG works)
	    if $MOZ_CONFIG --libs >/dev/null 2>&1; then
	        AC_MSG_RESULT(yes)
		MOZ_CONFIG_LIBS="`$MOZ_CONFIG --libs`"
		MOZ_CONFIG_CFLAGS="`$MOZ_CONFIG --cflags`"
	    else
	        AC_MSG_RESULT(no)
		AC_MSG_ERROR(No working mozilla-config script)
            fi
        fi

])
