/* $Id: uucode.h,v 1.4 2004/01/02 03:54:01 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef __UUCODE_H__
#define __UUCODE_H__

/*
 * Encodes files and adds each to outfile.
 */
class UUEncode {
public:
	UUEncode();
	UUEncode(const char *outfile);
	~UUEncode();

	bool open(const char *outfile);
	void close();

	bool addFile(const char *infile);

private:
	bool isOpen;
	char tempfile[MAXPATHLEN], file[MAXPATHLEN];
	FILE *fp;
};

/*
 * Extract and decode multiple files from infile (or text part of inmsg).
 */
class UUDecode {
public:
	UUDecode();
	UUDecode(const char *infile);
	UUDecode(struct _mail_msg *inmsg);
	~UUDecode();
	
	bool open(const char *file);
	bool open(struct _mail_msg *msg);
	void close();

	const char *getNextFileName(void);
	bool getNextFile(const char *outfile);

private:
	bool isOpen;
	char tempfile[MAXPATHLEN];
	int mode;	// XXX saved mode from last file part
	
	FILE *fp;
};

#endif /* __UUCODE_H__ */
