/* $Id: help.cpp,v 1.9 2004/01/02 04:05:36 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "help.h"

static int ready = 0;
static int last = 0;
static int lastnodes[10];

extern cfgfile Config;

FD_Help_Form *help_obj;

void help(int chapter) {
	int i, redisp = 0, show = 0;
	int w, h;

	if(ready) {
		fl_activate_form(help_obj->Help_Form);
		XRaiseWindow(fl_display, help_obj->Help_Form->window);
		redisp = 1;
	}

	ready = 1;

	if(!redisp)
		help_obj = create_form_Help_Form();
	fl_freeze_form(help_obj->Help_Form);

	fl_clear_browser(help_obj->Help_Browser);

	if(chapter == 0) {
		chapter++;
		show = 1;
	}

	i = chapter;

	while(strcmp(help_txt[i], "%END")) {
		if(help_txt[i][0] == '%') {
			if(show) {
				i++;
				fl_add_browser_line(help_obj->Help_Browser, " ");
				continue;
			} else {
				break;
			}
		}

		if(strlen(help_txt[i]) < 1)
			fl_add_browser_line(help_obj->Help_Browser, "@N");
		else
			fl_add_browser_line(help_obj->Help_Browser, help_txt[i]);
		i++;
	}

	fl_set_object_callback(help_obj->Help_Browser, Help_Browser_Call,
						   chapter);
	fl_unfreeze_form(help_obj->Help_Form);

	if(redisp)
		return;

	Config.setFlags("helpgeom", CF_NOTCHANGED);
	w = 500;
	h = 300;
	sscanf(Config.get("helpgeom", "").c_str(), "%d %d", &w, &h);
	if(main_form)
		fl_set_initial_placement(help_obj->Help_Form, main_form->x,
								 main_form->y, w, h);
	else
		fl_set_form_size(help_obj->Help_Form, w, h);

	fl_set_form_minsize(help_obj->Help_Form, 400, 200);

	fl_show_form(help_obj->Help_Form, FL_PLACE_FREE, FL_TRANSIENT,
				 "Help for XFMail");

	return;
}

void cb_help_button(FL_OBJECT * obj, long param) {
	help(chapters[param]);

	return;
}

void Done_Help_Call(FL_OBJECT * obj, long param) {
	char geom[16];

	if(!ready)
		return;

	sprintf(geom, "%d %d", help_obj->Help_Form->w, help_obj->Help_Form->h);
	Config.set("helpgeom", geom);
	fl_hide_form(help_obj->Help_Form);
	fl_free_form(help_obj->Help_Form);
	fl_free(help_obj);
	help_obj = NULL;

	ready = 0;
	last = 0;
	return;
}

void Help_Browser_Call(FL_OBJECT * obj, long param) {
	int line = fl_get_browser(obj) + param;
	int i, link = 0;

	for(i = 0; i < NrOfLinks; i++)
		if(HelpLinks[i][0] == line) {
			link = HelpLinks[i][1];
			break;
		}

	if(last < 9)
		lastnodes[last++] = param;
	else {
		for(i = 0; i < 9; i++)
			lastnodes[i] = lastnodes[i + 1];
		lastnodes[9] = param;
	}

	if(link)
		help(link);
}

void Help_Top_Call(FL_OBJECT * obj, long param) {
	help(0);
}

void Help_Back_Call(FL_OBJECT * obj, long param) {
	if(last > 0) {
		last--;
		help(lastnodes[last]);
	}
}

void helpchapter(int chapter) {
	help(chapters[chapter]);
}
