#include "lcp3.h"

int get_max_lcp3_pack_size()
{
    int size = sizeof(struct t_lcp3_info_auth);
    if ( size < sizeof(struct t_lcp3_info_ack) ) size = sizeof(struct t_lcp3_info_ack);
    if ( size < sizeof(struct t_lcp3_info_line) ) size = sizeof(struct t_lcp3_info_line);
    if ( size < sizeof(struct t_lcp3_info_tput) ) size = sizeof(struct t_lcp3_info_tput);
    if ( size < sizeof(struct t_lcp3_info_status) ) size = sizeof(struct t_lcp3_info_status);
    if ( size < sizeof(struct t_lcp3_info_enckey) ) size = sizeof(struct t_lcp3_info_enckey);
    if ( size < sizeof(struct t_lcp3_info_isdn) ) size = sizeof(struct t_lcp3_info_isdn);
    size += sizeof(struct t_lcp3_cmd);
    return(size);
}

int get_lcp3_pack_size(int cmd)
{
    switch ( cmd )
    {
	case CMD3_AUTHREQ:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_auth));
	case CMD3_INVALID:
	case CMD3_NOACCESS:
	case CMD3_ACK:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_ack));
	case CMD3_LINE:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_line));
	case CMD3_STATUS:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_status));
	case CMD3_ENCINFO:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_enckey));
	case CBR3_TPUT:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_tput));
	case CBR3_ISDNACT:
	    return(sizeof(struct t_lcp3_cmd)+sizeof(struct t_lcp3_info_isdn));
	default:
	    return(sizeof(struct t_lcp3_cmd));
    }
}
