#include "widgets.h"

#include "support.h"

GtkWidget *wnd_config = NULL;
GtkWidget *wnd_activity = NULL;
GtkWidget *wnd_linemaster = NULL;
GtkWidget *wnd_messages = NULL;
GtkWidget *wnd_conserver = NULL;
GtkWidget *wnd_autohup = NULL;
GtkWidget *wnd_passwd = NULL;

struct twdg_config * wdg_config;
struct twdg_activity * wdg_activity;
struct twdg_linemaster * wdg_linemaster;
struct twdg_messages * wdg_messages;
struct twdg_conserver * wdg_conserver;
struct twdg_autohup * wdg_autohup;
struct twdg_passwd * wdg_passwd;

const char * wdg_names_config[] = {
	"ent_srv_hostname",
	"sp_srv_port",
	"ent_username",
	"ent_passwd",
	"opt_mn_protocol",
	"chk_srv_autoconnect",
	"chk_srv_reconnect",
	"chk_save_passwd",
	"chk_wnd_events",
	"chk_start_minimized",
	NULL
};

const char * wdg_names_activity[] = {
	"prg_up",
	"prg_down",
	NULL
};

const char * wdg_names_linemaster[] = {
	"mn_server_connect",
	"mn_server_disconnect",
	"mn_server_show_message_window",
	"mn_line_online",
	"mn_line_offline",
	"mn_line_wnd_activity",
	"mn_line_isdnchannels",
	"mn_line_autohangup",
	"cl_lines",
	"lb_line_status",
	"lb_client_status",
	"lb_server_time",
	"lb_client_time",
	"lb_channels",
	"lb_up_current",
	"lb_down_current",
	"lb_up_average",
	"lb_down_average",
	"lb_up_total",
	"lb_down_total",
	"lb_up_max",
	"lb_down_max",
	"lb_up_capab",
	"lb_down_capab",
	"chk_ahup",
	NULL
};

const char * wdg_names_messages[] = {
	"cl_messages",
	NULL
};

const char * wdg_names_conserver[] = {
	"chk_gotip",
	"chk_using_encryption",
	"chk_logged_in",
	"chk_lines",
	"lb_status",
	NULL
};

const char * wdg_names_autohup[] = {
	"cb_ahup_lines",
	"chk_ahup_activated",
	"chk_ahup_activity_mode",
	"chk_ahup_time",
	"chk_ahup_up",
	"chk_ahup_down",
	"chk_ahup_total_up",
	"chk_ahup_total_down",
	"sp_ahup_time",
	"sp_ahup_up",
	"sp_ahup_down",
	"sp_ahup_total_up",
	"sp_ahup_total_down",
	"rb_ahup_or",
	"rb_ahup_and",
	NULL
};

const char * wdg_names_passwd[] = {
	"ent_passwd_name",
	"ent_passwd_passwd",
	NULL
};

void widgets_init()
{
	wdg_config = g_malloc(sizeof(struct twdg_config));
	wdg_activity = g_malloc(sizeof(struct twdg_activity));
	wdg_linemaster = g_malloc(sizeof(struct twdg_linemaster));
	wdg_messages = g_malloc(sizeof(struct twdg_messages));
	wdg_conserver = g_malloc(sizeof(struct twdg_conserver));
	wdg_autohup = g_malloc(sizeof(struct twdg_autohup));
	wdg_passwd = g_malloc(sizeof(struct twdg_passwd));
	wdg_config->realized = FALSE;
	wdg_activity->realized = FALSE;
	wdg_linemaster->realized = FALSE;
	wdg_messages->realized = FALSE;
	wdg_messages->msgs = NULL;
	wdg_conserver->realized = FALSE;
	wdg_autohup->realized = FALSE;
	wdg_autohup->realized = FALSE;
}

inline void widgets_load(GtkWidget *parent, const char * names[], gpointer * ptrs[])
{
	while ( *names )
	{
		*ptrs = (gpointer*)lookup_widget(parent, *names);
		if ( !*ptrs )
			g_print("can't find widget '%s'.\n", *names);
		ptrs++;
		names++;
	}
}

/*
  Attention:
	arg 3 of widgets_load should be a 'gpointer * []' but we give it
	a 'struct twdg_<name> *' casted into a 'void *'.
	This will cause widgets_load() to directly access the gpointers
	stored in the structs twdg_<name>.
*/
void widgets_load_wdg_config() { widgets_load(wnd_config, wdg_names_config, (void *)wdg_config); wdg_config->realized = TRUE; }
void widgets_load_wdg_activity() { widgets_load(wnd_activity, wdg_names_activity, (void *)wdg_activity); wdg_activity->realized = TRUE; }
void widgets_load_wdg_linemaster() { widgets_load(wnd_linemaster, wdg_names_linemaster, (void *)wdg_linemaster); wdg_linemaster->realized = TRUE; }
void widgets_load_wdg_messages() { widgets_load(wnd_messages, wdg_names_messages, (void *)wdg_messages); wdg_messages->realized = TRUE; }
void widgets_load_wdg_conserver() { widgets_load(wnd_conserver, wdg_names_conserver, (void *)wdg_conserver); wdg_conserver->realized = TRUE; }
void widgets_load_wdg_autohup() { widgets_load(wnd_autohup, wdg_names_autohup, (void *)wdg_autohup); wdg_autohup->realized = TRUE; }
void widgets_load_wdg_passwd() { widgets_load(wnd_passwd, wdg_names_passwd, (void *)wdg_passwd); wdg_passwd->realized = TRUE; }
