#include <gtk/gtk.h>

#include <netinet/in.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>

#include "cfg.h"
#include "user.h"
#include "widgets.h"
#include "runtime.h"
#include "args.h"
#include "../config.h"
#include "mysql_backend.h"

#define DEFAULT_CFG_FILENAME "xlc.cfg"

struct tConfig * config;

char * cfgfile = NULL; /* config filename given as argument */

int config_load_defaults()
{
	if ( !(config = g_malloc(sizeof(struct tConfig))) ) return(0);
	config->server_hostname = NULL;
	config->server_port = htons(16007);
	config->server_connect_on_startup = FALSE;
	config->server_try_reconnecting = FALSE;
	config->user_name = NULL;
	config->user_passwd = NULL;
	config->user_save_passwd = TRUE;
	config->misc_event_window = FALSE;
	config->wnd_linemaster_x = 0;
	config->wnd_linemaster_y = 0;
	config->wnd_linemaster_w = 700;
	config->wnd_linemaster_h = 250;
	config->wnd_messages_w = 400;
	config->wnd_messages_h = 140;
	config->wnd_activity_x = 0;
	config->wnd_activity_y = 0;
	config->wnd_activity_show = FALSE;
	config->default_line = 0;
	config->start_minimized = FALSE;
	config->online_script = NULL;
	config->offline_script = NULL;
	config->mysql_enable = FALSE;
	config->addrbook_ask = TRUE;
	config->mysql_host = NULL;
	config->mysql_user = NULL;
	config->mysql_pass = NULL;
	config->mysql_db = NULL;
	config->detach = FALSE;
	return(1);
}


#ifdef DEBUG
void config_dump()
{
	g_print("--- CONFIG ---\n");
	g_print("config file: %s\n", cfgfile);
	g_print("server_hostname: %s\n", config->server_hostname);
	g_print("server_port: %d\n", ntohs(config->server_port));
	g_print("server_connect_on_startup: %d\n", config->server_connect_on_startup);
	g_print("server_try_reconnecting: %d\n", config->server_try_reconnecting);
	g_print("user_name: %s\n", config->user_name);
	g_print("user_passwd: ***\n"); //, config->user_passwd);
	g_print("user_save_passwd: %d\n", config->user_save_passwd);
	g_print("misc_event_window: %d\n", config->misc_event_window);
	g_print("wnd_linemaster_x: %d\n", config->wnd_linemaster_x);
	g_print("wnd_linemaster_y: %d\n", config->wnd_linemaster_y);
	g_print("wnd_linemaster_w: %d\n", config->wnd_linemaster_w);
	g_print("wnd_linemaster_h: %d\n", config->wnd_linemaster_h);
	g_print("wnd_messages_w: %d\n", config->wnd_messages_w);
	g_print("wnd_messages_h: %d\n", config->wnd_messages_h);
	g_print("wnd_activity_x: %d\n", config->wnd_activity_x);
	g_print("wnd_activity_y: %d\n", config->wnd_activity_y);
	g_print("wnd_activity_show: %d\n", config->wnd_activity_show);
	g_print("default_line: %d\n", config->default_line);
	g_print("start_minimized: %d\n", config->start_minimized);
	g_print("online_script: %s\n", config->online_script);
	g_print("offline_script: %s\n", config->offline_script);
	g_print("mysql_enable: %d\n", config->mysql_enable);
	g_print("mysql_host: %s\n", config->mysql_host);
	g_print("mysql_user: %s\n", config->mysql_user);
	g_print("mysql_pass: ***\n");
	g_print("mysql_db: %s\n", config->mysql_db);
	g_print("addrbook_ask: %d\n", config->addrbook_ask);
	g_print("--------------\n");
}
#endif	// config_dump() only with DEBUG available!

int config_load()
{
#define READ_GBOOL(b)		if ( fscanf(fh, "%d", &dum) ) { if ( dum ) config->b = TRUE; else config->b = FALSE; }
#define READ_INT(b)			fscanf(fh, "%d", &config->b);
#define READ_STRING(s)	do { sdum[0] = '\0'; fscanf(fh, "%s", sdum); if (sdum[0] != '\0') config->s = g_strdup(sdum); } while (0)
	FILE * fh = NULL;
	int dum;
	char sdum[200];
	char * cfg_fname_sys = "/etc/"DEFAULT_CFG_FILENAME;
	char * cfg_fname_user = user_get_homedir(getuid());
	strcat(cfg_fname_user, "/."DEFAULT_CFG_FILENAME);
	*sdum = 0;
	
	if ( cfgfile ) fh = fopen(cfgfile, "r");
	if ( !fh )
	{
		if ( !(fh = fopen(cfg_fname_user, "r")) )
		{
			if ( !(fh = fopen(cfg_fname_sys, "r")) )
				return(0);
			else cfgfile = strdup(cfg_fname_sys);
		}
		else cfgfile = strdup(cfg_fname_user);
	}

	fscanf(fh, "%s", sdum); config->server_hostname = g_strdup(sdum);
	fscanf(fh, "%d", (int*)&(config->server_port));
		config->server_port = htons(config->server_port);
	READ_GBOOL(server_connect_on_startup);
	READ_GBOOL(server_try_reconnecting);
	fscanf(fh, "%s", sdum); config->user_name = g_strdup(sdum);
	fscanf(fh, "%s", sdum); config->user_passwd = g_strdup(sdum);
	READ_GBOOL(user_save_passwd)
	READ_GBOOL(misc_event_window)
	READ_INT(wnd_linemaster_x)
	READ_INT(wnd_linemaster_y)
	READ_INT(wnd_linemaster_w)
	READ_INT(wnd_linemaster_h)
	READ_INT(wnd_messages_w)
	READ_INT(wnd_messages_h)
	READ_INT(wnd_activity_x)
	READ_INT(wnd_activity_y)
	READ_GBOOL(wnd_activity_show);
	READ_INT(default_line);
	READ_GBOOL(start_minimized);
	READ_STRING(online_script);
	READ_STRING(offline_script);
	READ_GBOOL(mysql_enable);
	READ_STRING(mysql_host);
	READ_STRING(mysql_user);
	READ_STRING(mysql_pass);
	READ_STRING(mysql_db);
	READ_GBOOL(addrbook_ask);
	if ( !config->user_save_passwd )
	{
		g_free(config->user_passwd);
		config->user_passwd = NULL;
	}
	fclose(fh);
	#ifdef DEBUG
		config_dump();
	#endif
	return(1);
}

int config_save()
{
#define WRITE_GBOOL(b)	if ( config->b ) fprintf(fh, "1\n"); else fprintf(fh, "0\n");
#define WRITE_INT(b)	fprintf(fh, "%d\n", config->b);
#define WRITE_STRING(s)	{ if ( config->s ) fprintf(fh, "%s\n", config->s); else fprintf(fh, "\n"); }
	FILE * fh;
/*	char * cfg_fname_user = user_get_homedir(getuid());
	strcat(cfg_fname_user, "/.xlc.cfg");*/
/*	if ( !(fh = fopen(cfg_fname_user, "w")) ) return(0);*/
/*	if ( (!cfgfile) || (!(fh = fopen(cfgfile, "w"))) ) return 0;*/
	if ( !cfgfile )
	{
		cfgfile = user_get_homedir(getuid());
		if ( !cfgfile ) return 0;
		strcat(cfgfile, "/."DEFAULT_CFG_FILENAME);
	}
	if ( !(fh = fopen(cfgfile, "w")) ) return 0;

	fchmod(fileno(fh), S_IRUSR | S_IWUSR);
	WRITE_STRING(server_hostname)
	fprintf(fh, "%d\n", ntohs(config->server_port));
	WRITE_GBOOL(server_connect_on_startup);
	WRITE_GBOOL(server_try_reconnecting)
	WRITE_STRING(user_name)
	if ( config->user_save_passwd )
	{
		fprintf(fh, "%s\n", config->user_passwd);
	}
	else fprintf(fh, "-*-\n");
	WRITE_GBOOL(user_save_passwd)
	WRITE_GBOOL(misc_event_window)
	WRITE_INT(wnd_linemaster_x)
	WRITE_INT(wnd_linemaster_y)
	WRITE_INT(wnd_linemaster_w)
	WRITE_INT(wnd_linemaster_h)
	WRITE_INT(wnd_messages_w)
	WRITE_INT(wnd_messages_h)
	WRITE_INT(wnd_activity_x)
	WRITE_INT(wnd_activity_y)
	WRITE_GBOOL(wnd_activity_show)
	WRITE_INT(default_line)
	WRITE_GBOOL(start_minimized);
	WRITE_STRING(online_script)
	WRITE_STRING(offline_script)
	WRITE_GBOOL(mysql_enable);
	WRITE_STRING(mysql_host);
	WRITE_STRING(mysql_user);
	WRITE_STRING(mysql_pass);
	WRITE_STRING(mysql_db);
	WRITE_GBOOL(addrbook_ask);
	fclose(fh);
	#ifdef DEBUG
		config_dump();
	#endif
	return(1);
}

int config_init()
{
	if ( !config_load_defaults() ) return(0);
	args_parse();
	config_load();
	optind = 0; /* parse arguments again */
	args_parse();
	#if HAVE_LIBMYSQL
		if ( config->mysql_enable )
			sqlbe_init(
					config->mysql_host,
					config->mysql_user,
					config->mysql_pass,
					config->mysql_db
				);
	#endif
	return(1);
}

FILE * config_ahup_open_read()
{
	FILE * fh;
	char * cfg_fname_sys = "/etc/xlc.ahup";
	char * cfg_fname_user = user_get_homedir(getuid());
	strcat(cfg_fname_user, "/.xlc.ahup");
	if ( runtime->autohup_file ) fclose(runtime->autohup_file);
	runtime->autohup_file = NULL;
	if ( !(fh = fopen(cfg_fname_user, "r")) )
		if ( !(fh = fopen(cfg_fname_sys, "r")) )
			return(NULL);
	runtime->autohup_file = fh;
	return(fh);
}

FILE * config_ahup_open_write()
{
	char * cfg_fname_user = user_get_homedir(getuid());
	strcat(cfg_fname_user, "/.xlc.ahup");
	if ( runtime->autohup_file ) fclose(runtime->autohup_file);
	runtime->autohup_file = fopen(cfg_fname_user, "w");
	return(runtime->autohup_file);
}
