#ifndef _WIDGETS_H
#define _WIDGETS_H

#include <gtk/gtk.h>

#include "widgets_cmn.h"

#include "runtime.h"

void widgets_init();

void widgets_load_wdg_config();
void widgets_load_wdg_activity();
void widgets_load_wdg_linemaster();
void widgets_load_wdg_messages();
void widgets_load_wdg_conserver();
void widgets_load_wdg_autohup();
void widgets_load_wdg_passwd();

extern GtkWidget *wnd_config;
extern GtkWidget *wnd_activity;
extern GtkWidget *wnd_linemaster;
extern GtkWidget *wnd_messages;
extern GtkWidget *wnd_conserver;
extern GtkWidget *wnd_autohup;
extern GtkWidget *wnd_passwd;

/*
	about the "struct twdg_*":
	- the position of "gboolean realized" matters!
	- add new widgetnames to the wdg_names_* arrays
	  in widgets.c too.
	- every window has it's own twdg_<n> and wdg_names_<n>
	  as well as a GtkWidget *wnd_<n> pointer.
*/

struct twdg_activity
{
	GtkProgressBar * prg_up;
	GtkProgressBar * prg_down;
	gboolean realized;
};
extern struct twdg_activity * wdg_activity;

struct twdg_linemaster
{
	GtkMenuItem * mn_server_connect;
	GtkMenuItem * mn_server_disconnect;
	GtkMenuItem * mn_server_show_message_window;
	GtkMenuItem * mn_line_online;
	GtkMenuItem * mn_line_offline;
	GtkCheckMenuItem * mn_line_wnd_activity;
	GtkCheckMenuItem * mn_line_isdnchannels;
	GtkMenuItem * mn_line_autohangup;
	GtkCList * cl_lines;
	GtkLabel * lb_line_status;
	GtkLabel * lb_client_status;
	GtkLabel * lb_server_time;
	GtkLabel * lb_client_time;
	GtkLabel * lb_channels;
	GtkLabel * lb_up_current;
	GtkLabel * lb_down_current;
	GtkLabel * lb_up_average;
	GtkLabel * lb_down_average;
	GtkLabel * lb_up_total;
	GtkLabel * lb_down_total;
	GtkLabel * lb_up_max;
	GtkLabel * lb_down_max;
	GtkLabel * lb_up_capab;
	GtkLabel * lb_down_capab;
	GtkCheckButton * chk_ahup;
	gboolean realized;
};
extern struct twdg_linemaster * wdg_linemaster;

struct twdg_messages
{
	GtkCList * cl_messages;
	gboolean realized;
	GList * msgs;
};
struct tmsg
{
	gchar * row[2];
};
extern struct twdg_messages * wdg_messages;

struct twdg_config
{
	GtkEntry * ent_srv_hostname;
	GtkSpinButton * sp_srv_port;
	GtkEntry * ent_username;
	GtkEntry * ent_passwd;
	GtkOptionMenu * opt_mn_protocol;
	GtkCheckButton * chk_srv_autoconnect;
	GtkCheckButton * chk_srv_reconnect;
	GtkCheckButton * chk_save_passwd;
	GtkCheckButton * chk_wnd_events;
	GtkCheckButton * chk_start_minimized;
	GtkEntry * ent_online;
	GtkEntry * ent_offline;
	GtkEntry * ent_mysql_host;
	GtkEntry * ent_mysql_user;
	GtkEntry * ent_mysql_pass;
	GtkEntry * ent_mysql_db;
	GtkLabel * lb_mysql_host;
	GtkLabel * lb_mysql_user;
	GtkLabel * lb_mysql_pass;
	GtkLabel * lb_mysql_db;
	GtkCheckButton * chk_mysql_enable;
	GtkCheckButton * chk_addrbook_ask;
	gboolean realized;
};
extern struct twdg_config * wdg_config;

struct twdg_conserver
{
	GtkCheckButton * chk_gotip;
	GtkCheckButton * chk_using_encryption;
	GtkCheckButton * chk_logged_in;
	GtkCheckButton * chk_lines;
	GtkLabel * lb_status;
	gboolean realized;
};
extern struct twdg_conserver * wdg_conserver;

struct twdg_autohup
{
	GtkCombo * cb_ahup_lines;
	GtkCheckButton * chk_ahup_activated;
	GtkCheckButton * chk_ahup_activity_mode;
	GtkCheckButton * chk_ahup_time;
	GtkCheckButton * chk_ahup_up;
	GtkCheckButton * chk_ahup_down;
	GtkCheckButton * chk_ahup_total_up;
	GtkCheckButton * chk_ahup_total_down;
	GtkSpinButton * sp_ahup_time;
	GtkSpinButton * sp_ahup_up;
	GtkSpinButton * sp_ahup_down;
	GtkSpinButton * sp_ahup_total_up;
	GtkSpinButton * sp_ahup_total_down;
	GtkRadioButton * rb_ahup_or;
	GtkRadioButton * rb_ahup_and;
	gboolean realized;
	GList * linenames;
	struct tline * selected_line;
};
extern struct twdg_autohup * wdg_autohup;

struct twdg_passwd
{
	GtkEntry * ent_passwd_name;
	GtkEntry * ent_passwd_passwd;
	gboolean realized;
};
extern struct twdg_passwd * wdg_passwd;

#endif
