
/*
 * DEFS.H
 *
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>

#define Prototype	extern

struct INode;

typedef struct Node {
    struct Node	*no_Next;
    struct Node	*no_Prev;
    char	*no_Name;	/* cannot be NULL if a node	*/
    int		no_Value;
    struct INode *no_INode;	/* include node			*/
    int		no_ILine;	/* line number in include	*/
    int		no_Size;	/* size of node in bytes	*/
    int		no_Type;
} Node;

typedef struct List {
    Node	li_Node;	/* li_Node.no_Name == NULL, no_Value == count  */
    int		li_Refs;	/* shared references		*/
} List;

#define li_Count	li_Node.no_ILine

typedef struct INode {
    Node	in_Node;
    FILE	*in_Fi;
    List	in_EList;	/* token expansion list		*/
    int		in_LastNl;
    struct INode *in_Parent;
} INode;

typedef struct VNode {
    Node	vn_Node;
    List	vn_List;
} VNode;

typedef struct Depend {
    Node	de_Node;
    struct Depend *de_Chain;
    List	*de_XList;	/* execution list			*/
    List	de_Lhs;		/* lhs (one element)			*/
    List	*de_Rhs;	/* rhs (N elements)			*/
} Depend;

typedef struct DNode {
    Node	dn_Node;
    Depend	*dn_Depend;
} DNode;

#define INITLIST(var)	{ { &var.li_Node, &var.li_Node, NULL, 0 }, 1 }

#include "xmake-protos.h"

#define EXITSTATUS	0
#define FATALEXIT	1
#define MAXLINE		16384
#define MAXVARIND	10

#define TYPE_VARTMP	-16
#define TYPE_VAR	-17
#define TYPE_EXEC	-18

#define DEPEND_NOTRUN	-2
#define DEPEND_UPTODATE	-1

#define EXP_DELAY	0
#define EXP_NORMAL	1
#define EXP_FORCE	2

#define INCLS	"-I. -I.. -I$HOME/.xmk -I/usr/local/share/xmk -I/usr/share/xmk"

/*
 * Set correct CPPCMD here.
 */

/*
 * Normal CPP
 */

/* #define CPPCMD	"cpp -DXMAKE -nostdinc " INCLS */

/*
 * Use GCC for CPP
 */

#define CPPCMD	"gcc -E -DXMAKE -nostdinc " INCLS " -x c"

