/*
 * xload - display system load average in a window
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * $XConsortium: xload.c,v 1.36 91/05/24 16:57:46 converse Exp $
 */

#include <stdio.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include "MemStripChart.h"
#include <X11/Xaw/StripChart.h>
#include <X11/Xmu/SysUtil.h>

/* #include <X11/Wc/WcCreateP.h> */

#include "xmem.bit"

extern void exit();

#include "get_mem.h"

static void quit();

/*
 * Definition of the Application resources structure.
 */

typedef struct _XLoadResources {
    Boolean show_label;
    Boolean use_lights;
} XLoadResources;

/*
 * Command line options table.  Only resources are entered here...there is a
 * pass over the remaining options after XtParseCommand is let loose.
 */

static XrmOptionDescRec options[] = {
    {"-scale",		"*load.minScale",	XrmoptionSepArg,	NULL},
    {"-update",		"*load.update",		XrmoptionSepArg,	NULL},
    {"-hl",		"*load.highlight",	XrmoptionSepArg,	NULL},
    {"-highlight",		"*load.highlight",	XrmoptionSepArg,	NULL},
    {"-jumpscroll",	"*load.jumpScroll",	XrmoptionSepArg,	NULL},
    {"-label",		"*label.label",		XrmoptionSepArg,	NULL},
    {"-nolabel",		"*showLabel",	        XrmoptionNoArg,       "False"},
    {"-lights",		"*useLights",		XrmoptionNoArg,	      "True"},
};

static XrmOptionDescRec options_mem[] = {
    {"-scale",		"*mem.minScale",	XrmoptionSepArg,	NULL},
    {"-update",		"*mem.update",		XrmoptionSepArg,	NULL},
    {"-hl",		"*mem.highlight",	XrmoptionSepArg,	NULL},
    {"-highlight",		"*mem.highlight",	XrmoptionSepArg,	NULL},
    {"-codecolor",		"*mem.codecolor",       XrmoptionSepArg,	NULL},
    {"-cahedcolor",	"*mem.cachedcolor",	XrmoptionSepArg,	NULL},
    {"-buffercolor",	"*mem.buffercolor",	XrmoptionSepArg,	NULL},
    {"-freecolor",		"*mem.freecolor",	XrmoptionSepArg,	NULL},
    {"-swapcolor",		"*mem.swapcolor",	XrmoptionSepArg,	NULL},
    {"-jumpscroll",	"*mem.jumpScroll",	XrmoptionSepArg,	NULL},
    {"-label",		"*label.label",		XrmoptionSepArg,	NULL},
    {"-nolabel",		"*showLabel",	        XrmoptionNoArg,       "False"},
    {"-lights",		"*useLights",		XrmoptionNoArg,	      "True"},
};

/*
 * The structure containing the resource information for the
 * Xload application resources.
 */

#define Offset(field) (XtOffsetOf(XLoadResources, field))

static XtResource my_resources[] = {
    {"showLabel", XtCBoolean, XtRBoolean, sizeof(Boolean),
	 Offset(show_label), XtRImmediate, (XtPointer) TRUE},
    {"useLights", XtCBoolean, XtRBoolean, sizeof(Boolean),
	 Offset(use_lights), XtRImmediate, (XtPointer) FALSE},
};

static XtResource my_resources_mem[] = {
    {"showLabel", XtCBoolean, XtRBoolean, sizeof(Boolean),
	 Offset(show_label), XtRImmediate, (XtPointer) TRUE},
};

#undef Offset

static XLoadResources resources;

static XtActionsRec xload_actions[] = {
    { "quit",	quit },
};
static Atom wm_delete_window;
static int light_update = 10 * 1000;

/*
 * Exit with message describing command line format.
 */

void usage(char *progname)
{
    fprintf (stderr, "usage:  %s [-options ...]\n\n", progname);
    fprintf (stderr, "where options include:\n");
    fprintf (stderr,
	     "    -display dpy            X server on which to display\n");
    fprintf (stderr,
	     "    -geometry geom          size and location of window\n");
    fprintf (stderr,
	     "    -fn font                font to use in label\n");
    fprintf (stderr,
	     "    -update seconds         interval between updates\n");
    fprintf (stderr,
	     "    -label string           annotation text\n");
    fprintf (stderr,
	     "    -bg color               background color\n");
    fprintf (stderr,
	     "    -fg color               text color\n");

    fprintf (stderr,
	     "    -hl color               scale color\n");
    fprintf (stderr,
	     "    -codecolor color        used code and stack memory color\n");
    fprintf (stderr,
	     "    -cachedcolor color      used cached memory color\n");
    fprintf (stderr,
	     "    -buffercolor color      used buffer memory color\n");
    fprintf (stderr,
	     "    -freecolor color        used free memory color\n");
    fprintf (stderr,
	     "    -swapcolor color        used swap memory color\n");
    fprintf (stderr,
	     "    -nolabel                removes the label from above the chart.\n");
    fprintf (stderr,
	     "    -jumpscroll value       number of pixels to scroll on overflow\n");
    fprintf (stderr,
	     "The reference line refers to the avaible installed ram\n");

    fprintf (stderr, "\n");
    exit(1);
}

int main(argc, argv)
    int argc;
    char **argv;
{
    XtAppContext app_con;
    Widget toplevel, load, pane, label_wid, load_parent;
    Arg args[1];
    Pixmap icon_pixmap = None;
    char *label, host[256];
    char *lastslash;

    /* For security reasons, we reset our uid/gid after doing the necessary
       system initialization and before calling any X routines. */

    InitMemLoadPoint();

    setgid(getgid());		/* reset gid first while still (maybe) root */
    setuid(getuid());

    toplevel = XtAppInitialize(&app_con, "XMem", options_mem, XtNumber(options_mem),
			       &argc, argv, NULL, NULL, (Cardinal) 0);

    if (argc != 1) usage(argv[0]);

    XtGetApplicationResources( toplevel, (XtPointer) &resources,
			      my_resources_mem, XtNumber(my_resources_mem),
			      NULL, (Cardinal) 0);
    /*
     * This is a hack so that f.delete will do something useful in this
     * single-window application.
     */
    XtAppAddActions (app_con, xload_actions, XtNumber(xload_actions));
    XtOverrideTranslations(toplevel,
			   XtParseTranslationTable ("<Message>WM_PROTOCOLS: quit()"));

    XtSetArg (args[0], XtNiconPixmap, &icon_pixmap);
    XtGetValues(toplevel, args, ONE);
    if (icon_pixmap == None) {
	XtSetArg(args[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       XtScreen(toplevel)->root,
				       (char *)xload_bits,
				       xload_width, xload_height));
	XtSetValues (toplevel, args, ONE);
    }

    if (resources.show_label) {
	pane = XtCreateManagedWidget ("paned", panedWidgetClass,
				      toplevel, NULL, ZERO);

	label_wid = XtCreateManagedWidget ("label", labelWidgetClass,
					   pane, NULL, ZERO);

	XtSetArg (args[0], XtNlabel, &label);
	XtGetValues(label_wid, args, ONE);

	if ( strcmp("label", label) == 0 ) {
	    (void) XmuGetHostname (host, 255);
	    XtSetArg (args[0], XtNlabel, host);
	    XtSetValues (label_wid, args, ONE);
	}

	load_parent = pane;
    }
    else
	load_parent = toplevel;


    load = XtCreateManagedWidget ("mem", memStripChartWidgetClass,
				  load_parent, NULL, ZERO);
    XtAddCallback(load, XtNgetValue, (void*)GetMemLoadPoint, NULL);

    XtRealizeWidget (toplevel);
    wm_delete_window = XInternAtom (XtDisplay(toplevel), "WM_DELETE_WINDOW",
				    False);
    (void) XSetWMProtocols (XtDisplay(toplevel), XtWindow(toplevel),
			    &wm_delete_window, 1);

    XtAppMainLoop(app_con);
}


static void quit (w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    if (event->type == ClientMessage &&
        event->xclient.data.l[0] != wm_delete_window) {
        XBell (XtDisplay(w), 0);
        return;
    }
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit (0);
}
