/*  
   xmms-sid - SIDPlay input plugin for X MultiMedia System (XMMS)

   SIDTune file information dialog
   
   Written by Matti "ccr" Hamalainen <mhamalai@ratol.fi>
   (Interface created with Glade, the Gtk+ interface builder)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xmms-sid.h"
#include <gtk/gtk.h>
#include <sidplay/sidtune.h>
#include <stdio.h>
#include <string.h>

static GtkWidget *xs_fileinfowin = NULL;
static GtkWidget *fileinfo_filename, *fileinfo_songname, *fileinfo_composer;
static GtkWidget *fileinfo_copyright, *fileinfo_ok, *fileinfo_sub_comment;
static GtkWidget *fileinfo_sub_tune, *fileinfo_sub_tune_menu, *fileinfo_sub_artist, *fileinfo_sub_title;


/*
 * Close the fileinfo
 */
void xs_fileinfo_ok(void)
{
  gtk_widget_destroy(xs_fileinfowin);
}


/*
 * Update the sub-tune information
 */
void xs_fileinfo_sub_tune(GtkWidget *widget, void *data)
{
 T_sid_stil_subtune *a_tune;
 GtkWidget *a_item;
 gint a_index;

 
 /* Get number of subtune */
 a_item  = gtk_menu_get_active(GTK_MENU(fileinfo_sub_tune_menu));
 a_index = g_list_index(GTK_MENU_SHELL(fileinfo_sub_tune_menu)->children, a_item);

 a_tune = &xs_stil_info.subtune[a_index];


 /* Get and set subtune information */
 if (a_tune->artist != NULL)
 gtk_entry_set_text (GTK_ENTRY (fileinfo_sub_artist), a_tune->artist);

 if (a_tune->title != NULL)
 gtk_entry_set_text (GTK_ENTRY (fileinfo_sub_title), a_tune->title);

 if (a_tune->comment != NULL) {

	/* Freeze the widget for update */
	gtk_text_freeze(GTK_TEXT(fileinfo_sub_comment));

	/* Delete the old comment */
	gtk_text_set_point(GTK_TEXT(fileinfo_sub_comment), 0);

	gtk_text_forward_delete(GTK_TEXT(fileinfo_sub_comment),
	gtk_text_get_length(GTK_TEXT(fileinfo_sub_comment)));

	/* Put in the new comment */	
	gtk_text_insert (GTK_TEXT (fileinfo_sub_comment), NULL, NULL, NULL,
	a_tune->comment, strlen(a_tune->comment));

	/* Un-freeze the widget */
	gtk_text_thaw(GTK_TEXT(fileinfo_sub_comment));
	}
}


/*
 * Execute the file-info dialog
 */
void xs_file_info_box(char *filename)
{
  GtkWidget *vbox14, *table1, *label16, *label17, *label18, *label19;
  GtkWidget *frame14, *vbox15, *glade_menuitem, *frame15, *alignment5;
  GtkWidget *table2, *label21, *label22, *scrolledwindow2;
  gint n;
  gchar tempstr[128];

  /* Get sidtune information */
  sidTune t(filename);
  if (!t) return;
  struct sidTuneInfo sidInf;
  t.getInfo(sidInf);

  /* Check if therea already is an open fileinfo window */
  if (xs_fileinfowin != NULL) {
	gdk_window_raise (xs_fileinfowin->window);
	return;
	}

  /* If not, create a new one */
  xs_fileinfowin = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect(GTK_OBJECT(xs_fileinfowin),"destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &xs_fileinfowin);
  gtk_object_set_data (GTK_OBJECT (xs_fileinfowin), "xs_fileinfowin", xs_fileinfowin);
  gtk_widget_set_usize (xs_fileinfowin, 400, 350);
  gtk_window_set_title (GTK_WINDOW (xs_fileinfowin), "xmms-sid fileinfo");
  gtk_window_set_position (GTK_WINDOW (xs_fileinfowin), GTK_WIN_POS_MOUSE);

  /* Start creating the widgets ! */
  vbox14 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox14);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "vbox14", vbox14, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox14);
  gtk_container_add (GTK_CONTAINER (xs_fileinfowin), vbox14);


  /* Song information */
  frame14 = gtk_frame_new ("Song Information:");
  gtk_widget_ref (frame14);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "frame14", frame14, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame14);
  gtk_box_pack_start (GTK_BOX (vbox14), frame14, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame14), 4);

  table1 = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "table1", table1, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame14), table1);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 4);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 2);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

  label16 = gtk_label_new ("Filename:");
  gtk_widget_ref (label16);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "label16", label16, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table1), label16, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label17 = gtk_label_new ("Songname:");
  gtk_widget_ref (label17);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "label17", label17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table1), label17, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label18 = gtk_label_new ("Composer:");
  gtk_widget_ref (label18);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "label18", label18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label18);
  gtk_table_attach (GTK_TABLE (table1), label18, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label19 = gtk_label_new ("Copyright:");
  gtk_widget_ref (label19);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "label19", label19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label19);
  gtk_table_attach (GTK_TABLE (table1), label19, 0, 1, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  fileinfo_filename = gtk_entry_new ();
  gtk_widget_ref (fileinfo_filename);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_filename", fileinfo_filename,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_filename);
  gtk_table_attach (GTK_TABLE (table1), fileinfo_filename, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (fileinfo_filename), FALSE);

  fileinfo_songname = gtk_entry_new ();
  gtk_widget_ref (fileinfo_songname);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_songname", fileinfo_songname,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_songname);
  gtk_table_attach (GTK_TABLE (table1), fileinfo_songname, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (fileinfo_songname), FALSE);

  fileinfo_composer = gtk_entry_new ();
  gtk_widget_ref (fileinfo_composer);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_composer", fileinfo_composer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_composer);
  gtk_table_attach (GTK_TABLE (table1), fileinfo_composer, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (fileinfo_composer), FALSE);

  fileinfo_copyright = gtk_entry_new ();
  gtk_widget_ref (fileinfo_copyright);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_copyright", fileinfo_copyright,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_copyright);
  gtk_table_attach (GTK_TABLE (table1), fileinfo_copyright, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (fileinfo_copyright), FALSE);


  /* Tune information */
  frame15 = gtk_frame_new ("Tune Information:");
  gtk_widget_ref (frame15);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "frame15", frame15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame15);
  gtk_box_pack_start (GTK_BOX (vbox14), frame15, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame15), 4);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox15);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "vbox15", vbox15, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox15);
  gtk_container_add (GTK_CONTAINER (frame15), vbox15);

  /* Sub-tune selection menu */
  fileinfo_sub_tune = gtk_option_menu_new ();
  gtk_widget_ref (fileinfo_sub_tune);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_sub_tune", fileinfo_sub_tune, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_sub_tune);
//  gtk_box_pack_start (GTK_BOX (vbox15), fileinfo_sub_tune, FALSE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox15), fileinfo_sub_tune, FALSE, FALSE, 2);

  /* -------------- */
  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (vbox15), table2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 4);

  label21 = gtk_label_new ("Title:");
  gtk_widget_ref (label21);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "label21", label21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label21);
  gtk_table_attach (GTK_TABLE (table2), label21, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label22 = gtk_label_new ("Artist:");
  gtk_widget_ref (label22);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "label22", label22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label22);
  gtk_table_attach (GTK_TABLE (table2), label22, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  fileinfo_sub_artist = gtk_entry_new ();
  gtk_widget_ref (fileinfo_sub_artist);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_sub_artist", fileinfo_sub_artist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_sub_artist);
  gtk_table_attach (GTK_TABLE (table2), fileinfo_sub_artist, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (fileinfo_sub_artist), FALSE);

  fileinfo_sub_title = gtk_entry_new ();
  gtk_widget_ref (fileinfo_sub_title);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_sub_title", fileinfo_sub_title,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_sub_title);
  gtk_table_attach (GTK_TABLE (table2), fileinfo_sub_title, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (fileinfo_sub_title), FALSE);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox15), scrolledwindow2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow2), 4);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  fileinfo_sub_comment = gtk_text_new (NULL, NULL);
  gtk_widget_ref (fileinfo_sub_comment);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_sub_comment", fileinfo_sub_comment,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_sub_comment);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), fileinfo_sub_comment);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0.1, 1);
  gtk_widget_ref (alignment5);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "alignment5", alignment5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (alignment5);
  gtk_box_pack_start (GTK_BOX (vbox14), alignment5, FALSE, FALSE, 0);

  fileinfo_ok = gtk_button_new_with_label ("Close");
  gtk_widget_ref (fileinfo_ok);
  gtk_object_set_data_full (GTK_OBJECT (xs_fileinfowin), "fileinfo_ok", fileinfo_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileinfo_ok);
  gtk_container_add (GTK_CONTAINER (alignment5), fileinfo_ok);
  GTK_WIDGET_SET_FLAGS (fileinfo_ok, GTK_CAN_DEFAULT);

  gtk_widget_grab_default (fileinfo_ok);


  /* Set the song informations */
  gtk_entry_set_text (GTK_ENTRY (fileinfo_filename), filename);
  gtk_entry_set_text (GTK_ENTRY (fileinfo_songname), sidInf.infoString[0]);
  gtk_entry_set_text (GTK_ENTRY (fileinfo_composer), sidInf.infoString[1]);
  gtk_entry_set_text (GTK_ENTRY (fileinfo_copyright), sidInf.infoString[2]);


  /* Sub-tune menu items */
  fileinfo_sub_tune_menu = gtk_menu_new ();

  /* "main tune" - the pseudo tune */
  glade_menuitem = gtk_menu_item_new_with_label ("General info");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (fileinfo_sub_tune_menu), glade_menuitem);
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			GTK_SIGNAL_FUNC (xs_fileinfo_sub_tune), fileinfo_sub_tune_menu);

  /* Other menu items */
  for (n = 1; n <= sidInf.songs; n++) {

	snprintf(tempstr, sizeof(tempstr), "Tune #%i", n);
	glade_menuitem = gtk_menu_item_new_with_label (tempstr);
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (fileinfo_sub_tune_menu), glade_menuitem);

	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			GTK_SIGNAL_FUNC (xs_fileinfo_sub_tune), fileinfo_sub_tune_menu);
	}

  gtk_option_menu_set_menu (GTK_OPTION_MENU (fileinfo_sub_tune), fileinfo_sub_tune_menu);

  /* Check if user wants STIL info */
  if (xs_cfg.usestil)
	xs_stil_get(filename);

  /* Set the sub-tune information */
  xs_fileinfo_sub_tune(NULL, fileinfo_sub_tune_menu);

  /* Connect the signals */
  gtk_signal_connect (GTK_OBJECT (fileinfo_ok), "clicked",
                      GTK_SIGNAL_FUNC (xs_fileinfo_ok),
                      NULL);

  /* Show the window */
  gtk_widget_show(xs_fileinfowin);
}
