/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_PLUGIN_H__
#define __DISPLAYER_PLUGIN_H__

#include <glib.h>
#include "singit_config.h"
#include "singit_song.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _DisplayerPlugin
{
	void *handle;          /* Filled in by main plugin */
	char *filename;        /* Filled in by main plugin */
	int xmms_session;      /* Filled in by main plugin */

	char *description;     /* The description that is shown in the preferences box */

	void (*init)(void);    /* Called when the displayer enabled */
	void (*show)(void);    /* Called when the displayer is shown */
	void (*hide)(void);    /* Called when the displayer is hidden */
	void (*toggle)(void);  /* Called when the displayer visual state should change */
	void (*finish)(void);  /* Called before the plugin is disabled */

	/* Call this with a pointer to your plugin struct to disable the plugin */
	void (*disable)(struct _DisplayerPlugin *);

	 /* Called when the global plugin configuration has been updated */
	void (*update)(const SingitConfigData *singit_config);

	/* Called by the main thread with the current song and time */
	void (*set_time)(guint, LSong*, GList *);

	void (*about)(void);           /* Show the plugin about box */
	void (*configure)(void);       /* Show the plugin configure box */
	void (*playback_start)(void);  /* Called when playback starts */
	void (*playback_stop)(void);   /* Called when playback stops */

	/* Render the PCM data, don't do anything time consuming in here - directly from xmms */
	void (*render_pcm)(gint16 pcm_data[2][512]);
	/* Render the freq data, don't do anything time consuming in here - directly from xmms */
	void (*render_freq)(gint16 freq_data[2][256]);
}
DisplayerPlugin;

void enable_plugin(gint plugin);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DISPLAYER_PLUGIN_H__
