/* SingIt Lyrics Displayer
 * Copyright (C) 2000, 2001 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 * colorbutton.h
 * original from LIBGIMP - Copyright (C) 1999 Sven Neumann
 * modified for SingIt - Copyright (C) 2000 Jan-Marek Glogowski
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* This provides a button with a color preview. The preview
 * can handle transparency by showing the checkerboard.
 * On click, a color selector is opened, which is already
 * fully functional wired to the preview button.
 */

#ifndef __COLOR_BUTTON_H__
#define __COLOR_BUTTON_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define TYPE_COLOR_BUTTON            (color_button_get_type ())
#define COLOR_BUTTON(obj)            (GTK_CHECK_CAST ((obj), TYPE_COLOR_BUTTON, ColorButton))
#define COLOR_BUTTON_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_COLOR_BUTTON, ColorButtonClass))
#define IS_COLOR_BUTTON(obj)         (GTK_CHECK_TYPE ((obj), TYPE_COLOR_BUTTON))
#define IS_COLOR_BUTTON_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_COLOR_BUTTON))

typedef struct _ColorButton       ColorButton;
typedef struct _ColorButtonClass  ColorButtonClass;

struct _ColorButton
{
  GtkButton   button;

  gboolean        double_color;

  gchar          *title;
  gpointer        color;
  gint            bpp;
  gint            width;
  gint            height;

  gdouble        *dcolor;
  GtkWidget      *preview;
  GtkWidget      *dialog;
  GtkItemFactory *item_factory;

  guchar         *even;
  guchar         *odd;
};

struct _ColorButtonClass
{
  GtkButtonClass parent_class;

  void (* color_changed) (ColorButton *gcb);
};


GtkType    color_button_get_type   (void);
GtkWidget *color_button_new        (gchar   *title,
				    gint     width,
				    gint     height,
				    guchar  *color,
				    gint     bpp);
GtkWidget *color_button_double_new (gchar   *title,
				    gint     width,
				    gint     height,
				    gdouble *color,
				    gint     bpp);
void       color_button_update     (ColorButton *gcb);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __COLOR_BUTTON_H__ */
