/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "singit_song.h"
#include "singit_song_private.h"

typedef enum {

	ME_UNKNOWN,

	META_UNKNOWN,
	META_SEQUENCE_NUMBER, META_TEXT_EVENT, META_COPYRIGHT,
	META_SEQUENCE_NAME, META_TRACK_INSTRUMENT_NAME, META_LYRIC,
	META_MARKER, META_CUE_POINT, META_END, META_SET_TEMPO,
	META_TIME_SIG, META_KEY_SIG, META_SPECIFIC,

	SYSEX
}
MidiEventType;

typedef enum {

	SS_UNKNOWN,

	NOTE_OFF, NOTE_ON, KEY_AFTER_TOUCH, CONTROL_CHANGE, PROG_CHANGE,
	CHANNEL_AFTER_TOUCH, PITCH_WHEEL_CHANGE

}
MidiSongStatus;

typedef struct _MidiEvent {

	gpointer       *data;
	MidiEventType   type;
	MidiSongStatus  running_status;

	gulong          delta_time;
	gulong          offset;
}
MidiEvent;

typedef struct _MidiFile {

	GList* file_start;  // List of Midi-Events
	GList* file_end;

	gchar* file_name;
}
MidiFile;

guint getInt32(gchar **buffer)
{
	guint result = 0;
	memcpy(*buffer, &result, 4);
	*buffer = (*buffer + 4);
	return result;
}

guint getInt16(gchar **buffer)
{
	guint result = 0;
	gchar *pos = (gchar *)(&result + 2);
	memcpy(*buffer, pos, 2);
	*buffer = (*buffer + 2);
	return result;
}

gint getIntVar(guchar **buffer)
{
	gint result = 0;
	guchar c = *buffer[0];
	*buffer = (*buffer + 1);

	result = c & 0x7f;
	while (c & 0x80) {
		guchar c = *buffer[0];
		*buffer = (*buffer + 1);
		result = (result <<7) | (c & 0x7f);
	}
	return result;
}

gint getIntVarT(gulong value, gchar **buffer)
{
	gchar *bufptr = *buffer;
	gboolean wr = FALSE;
	gint written = 0, i;

	for (i=4; i>=0; i--) {
		gint dep = 7*i;
		gint iv = (value >> dep);
		gint cv = iv & 0x7f;
		if ((cv>0) || wr || (i==0)) {
			wr = TRUE;
			if (i != 0) { cv |= 0x80; }
			*bufptr++ = (gchar) (cv & 0xFF);
			written++;
		}
	}
	*bufptr = 0;
	return written;
}

guchar getByte(gchar **buffer)
{
	gchar result = *buffer[0];
	*buffer = (*buffer + 1);
	return result;
}


MidiEvent *getMidiEvent(gchar *buffer, gint *length, gulong offset)
{
	gint command;
	MidiEvent *result = g_malloc(sizeof(MidiEvent));
	result->delta_time = getIntVar((guchar **) &buffer);
	result->offset = offset + result->delta_time;
	command = (gint) getByte(&buffer);
	result->data = NULL;

	/*
	if (command == 0xff) {
		command = IOUtils::getByte(in, length);
		int clen = IOUtils::getIntVar(in, length);

		switch (command) {
		case 0x00:
			MidiMetaSequenceNumber *mmsn = new MidiMetaSequenceNumber(clen);
			for (int i=0; i<clen; i++)
				{ mmsn->setSequence(i, IOUtils::getByte(in, length)); }
			_data = mmsn;
			_eventCode = META_SEQUENCE_NUMBER;
			return;
			break;
		case 0x01:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_TEXT_EVENT;
			return;
			break;
		case 0x02:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_COPYRIGHT;
			return;
			break;
		case 0x03:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_SEQUENCE_NAME;
			return;
			break;
		case 0x04:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_TRACK_INSTRUMENT_NAME;
			return;
			break;
		case 0x05:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_LYRIC;
			return;
			break;
		case 0x06:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_MARKER;
			return;
			break;
		case 0x07:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_CUE_POINT;
			return;
			break;
		case 0x2F:
			_data = NULL;
			_eventCode = META_END;
			return;
			break;
		case 0x51:
			int val = 0;
			for (int i=0; i<3; i++)
				{ val |= (IOUtils::getByte(in,length) << (8*(2-i))); }
			MidiMetaTempo *mmt = new MidiMetaTempo(val);
			_data = mmt;
			_eventCode = META_SET_TEMPO;
			return;
			break;
		case 0x58:
			int data1 = IOUtils::getByte(in,length);
			int data2 = IOUtils::getByte(in,length);
			int data3 = IOUtils::getByte(in,length);
			int data4 = IOUtils::getByte(in,length);
			_data = new MidiMetaTimeSignature(data1,data2,data3,data4);
			_eventCode = META_TIME_SIG;
			return;
			break;
		case 0x59:
			int data1 = IOUtils::getByte(in,length);
			int data2 = IOUtils::getByte(in,length);
			_data = new MidiMetaKeySignature(data1,data2);
			_eventCode = META_KEY_SIG;
			return;
			break;
		case 0x7F:
			MidiMetaTextEvent *mmte = new MidiMetaTextEvent(clen);
			char *data = mmte->getDataBuffer();
			IOUtils::fillBuffer(in, data, clen, length);
			_data = mmte;
			_eventCode = META_SPECIFIC;
			return;
			break;
		}

		_eventCode = META_UNKNOWN;

		MidiGenericEvent *mge = new MidiGenericEvent(command, clen);
		char *data = mge->getBuffer();
		IOUtils::fillBuffer(in,data,clen, length);
		_data = mge;
		return;
	}


	if ((command == 0xF0) || (command == 0xF7)) {
		int clen = IOUtils::getIntVar(in, length);
		MidiGenericEvent *mge = new MidiGenericEvent(command, clen);
		char *data = mge->getBuffer();
		IOUtils::fillBuffer(in,data,clen, length);
		_data = mge;
		_eventCode = SYSEX;
		return;
	}

	char data1;
	if ((command & 0x80) == 0) {
		data1 = command;
		command = runningStatus;
		if (command == 0) {
			cerr << "ERROR !! NO RUNNING STATUS\n";
			exit(99);
		}
	}
	else {
		runningStatus = command;
		data1 = IOUtils::getByte(in,length);
	}



	switch( (command>>4) & 0xf ) {
	case 0x8:
		char channel, data2;
		channel = (command & 0xf);
		data2 = IOUtils::getByte(in,length);
		_data = new MidiEventCommand( command & 0xf, data1, data2);
		_eventCode = NOTE_OFF;
		return;
	case 0x9:
		char channel, data2;
		channel = (command & 0xf);
		data2 = IOUtils::getByte(in,length);
		_data = new MidiEventCommand( command & 0xf, data1, data2);
		_eventCode = NOTE_ON;
		return;
	case 0xA:
		char channel, data2;
		channel = (command & 0xf);
		data2 = IOUtils::getByte(in,length);
		_data = new MidiEventCommand( command & 0xf, data1, data2);
		_eventCode = KEY_AFTER_TOUCH;
		return;
	case 0xB:
		char channel, data2;
		channel = (command & 0xf);
		data2 = IOUtils::getByte(in,length);
		_data = new MidiEventCommand( command & 0xf, data1, data2);
		_eventCode = CONTROL_CHANGE;
		return;
	case 0xC:
		char channel;
		channel = (command & 0xf);
		_data = new MidiEventCommand( command & 0xf, data1, 0);
		_eventCode = PROG_CHANGE;
		return;
	case 0xD:
		char channel;
		channel = (command & 0xf);
		_data = new MidiEventCommand( command & 0xf, data1, 0);
		_eventCode = CHANNEL_AFTER_TOUCH;
		return;
	case 0xE:
		char channel, data2;
		channel = (command & 0xf);
		data2 = IOUtils::getByte(in,length);
		_data = new MidiEventCommand( command & 0xf, data1, data2);
		_eventCode = PITCH_WHEEL_CHANGE;
		return;
	}

	switch (runningStatus) {
	case 0x8: // note off
		_eventCode = NOTE_OFF;
		break;
	case 0x9: // note on
		_eventCode = NOTE_ON;
		break;
	case 0xA: // after touch
		_eventCode = KEY_AFTER_TOUCH;
		break;
	case 0xB: // control change
		_eventCode = CONTROL_CHANGE;
		break;
	case 0xC: // prog change
		_eventCode = PROG_CHANGE;
		break;
	case 0xD: // channel pressure
		_eventCode = CHANNEL_AFTER_TOUCH;
		break;
	case 0xE: // pitch wheel
		_eventCode = PITCH_WHEEL_CHANGE;
		break;
	default:
		_eventCode = ~0;
	}

	_data = new MidiEventCommand( runningStatus & 0xf , IOUtils::getByte(in,length), IOUtils::getByte(in,length));
	*/
	return NULL;
}


gboolean is_midi_file(gchar *buffer)
{
	return (!strncmp(buffer, "MThd", 4));
}

gboolean l_song_load_midi_lyrics(LSong *song, gchar *buffer)
{
	#ifdef CODEDEBUG
	DEBUG(("singit_song_midi.c [l_song_load_midi_lyrics] : "), 9);
	#endif

	if (is_midi_file(buffer)) {
		#ifdef CODEDEBUG
		DEBUG(("Is midi file - nothing else done yet\n"), 9);
		#endif
	}
	#ifdef CODEDEBUG
	else {
		DEBUG(("No / wrong midi file\n"), 9);
	}
	#endif
	return FALSE;
}
