/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_TOOLS_H__
#define __SINGIT_TOOLS_H__

#include <glib.h>

gchar* tools_replace_string(gchar *input_string, gchar *token, gchar *replacement);
gchar* tools_insert_string(gchar *input_string, gchar *token, guint offset);

/*
  Computes the intersection of line a and b (n = start / ln = length)  (n1 < n2 !)
  Returns TRUE if an intersection exists
*/
gboolean calc_line_intersection(gint a, guint la, gint b, guint lb, gint *r, guint *lr);

/*
  Computes the intersection of two rects (source, destination, result)
  Returns TRUE if an intersection exists
*/
gboolean calc_rect_intersection
	(gint left_s, gint top_s, guint width_s, guint height_s,
	 gint left_d, gint top_d, guint width_d, guint height_d,
	 gint *left_r, gint *top_r, guint *width_r, guint *height_r);

#endif // __SINGIT_TOOLS__
