/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2002  Peter Alm, Mikael Alm, Olle Hallnas,
 *                           Thomas Nilsson and 4Front Technologies
 *  Copyright (C) 1999-2002  Haavard Kvaalen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


// Heavily based on code form xmmsctrl.c and controlsocket.c
// from the XMMS package (www.xmms.org)

#include "protocol.h"
#include "socket.h"

#include "singit_debug.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif

static GList *packet_list;

static pthread_mutex_t packet_list_mutex
	= PTHREAD_MUTEX_INITIALIZER;

static inline void protcoll_write_gint(PacketNode *pkt, gint val)
{
	singit_socket_packet_write(pkt, &val, sizeof (gint));
}

static inline void protcoll_write_gfloat(PacketNode *pkt, gfloat val)
{
	singit_socket_packet_write
		(pkt, &val, sizeof (gfloat));
}

static inline void protcoll_write_gboolean(PacketNode *pkt, gboolean bool)
{
	singit_socket_packet_write
		(pkt, &bool, sizeof (gboolean));
}

static inline void protcoll_write_string(PacketNode *pkt, gchar * string)
{
	singit_socket_packet_write
		(pkt, string, string ? strlen(string) + 1 : 0);
}

gboolean protocoll_process_unlocked(PacketNode *pkt)
{
	switch (pkt->hdr.command)
	{
	case CMD_GET_VERSION:
		protcoll_write_gint(pkt, 0x09a3);
		singit_socket_packet_ack(pkt);
		break;
//	case CMD_GET_PLAYLIST_TIME:
//		if (pkt->data)
//			protcoll_write_gint(pkt->fd, playlist_get_songtime(*((guint32 *) pkt->data)));
//		else
//			protcoll_write_gint(pkt->fd, -1);
//			singit_socket_packet_ack(pkt);
//		break;
//	case CMD_PLAYLIST_CLEAR:
//		GDK_THREADS_ENTER();
//		playlist_clear();
//		GDK_THREADS_LEAVE();
//		singit_socket_packet_ack(pkt);
//		break;
	default:
		pthread_mutex_lock(&packet_list_mutex);
		packet_list = g_list_append(packet_list, pkt);
		singit_socket_packet_write(pkt, NULL, 0);
		close(pkt->fd);
		pthread_mutex_unlock(&packet_list_mutex);
		break;
	}

	return TRUE;
}

gboolean protocoll_process_locked(PacketNode *pkt)
{
	GList *pkt_list, *next;
	gpointer data;

	pthread_mutex_lock(&packet_list_mutex);
	for (pkt_list = packet_list; pkt_list; pkt_list = next)
	{
		pkt = pkt_list->data;
		data = pkt->data;

		switch (pkt->hdr.command)
		{
//			case CMD_PAUSE:
//				input_pause();
//				break;
//			case CMD_SET_SKIN:
//				load_skin(data);
//				break;
			case CMD_SHOW_PREFS_DLG:
//				show_prefs_window();
				break;
			case CMD_QUIT:
				/*
				 * We unlock the packet_list_mutex to
				 * avoid that cleanup_ctrlsocket() can
				 * deadlock, mainwin_quit_cb() will
				 * never return anyway, so this will
				 * work ok.
				 */
				pthread_mutex_unlock(&packet_list_mutex);
//				mainwin_quit_cb();
				break;
			default:
				g_log(NULL, G_LOG_LEVEL_MESSAGE,
					"Unknown socket command received");
				break;
		}
		next = g_list_next(pkt_list);
		packet_list = g_list_remove_link(packet_list, pkt_list);
		g_list_free_1(pkt_list);
		if (pkt->data)
			g_free(pkt->data);
		g_free(pkt);
	}

	pthread_mutex_unlock(&packet_list_mutex);

	return TRUE;
}
