/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __PROTOCOL_H__
#define __PROTOCOL_H__

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define SINGIT_PROTOCOL_VERSION		1

typedef enum _SingitCommand
{
	CMD_GET_VERSION,
	CMD_START_DISPLAYER,
	CMD_SHOW_PREFS_DLG,
	CMD_SHOW_ABOUT_DLG,
	CMD_SHOW_EDITOR_DLG,
	CMD_PLAYLIST_PREV,
	CMD_PING,
	CMD_MAIN_WIN_TOGGLE,
	CMD_QUIT,
	CMD_GET_CONFIG,
}
SingitCommand;

typedef struct
{
	guint16 version;
	guint16 command;
	guint32 data_length;
}
ClientPktHeader;

typedef struct
{
	guint16 version;
	guint32 data_length;
}
ServerPktHeader;

typedef struct
{
	ClientPktHeader hdr;
	gpointer data;
	gint fd;
}
PacketNode;

// void      protocoll_decode_package(gchar *data);
// gchar*    protocoll_encode_package(PacketNode *pkt)

// This funtion should be called directly in the socket handler
// It processes all fast / easy messages
gboolean protocoll_process_unlocked(PacketNode *pkt);

// This funtion should be called by the main program
// Before the call you __must__ lock the GDK_THREADS_MUTEX
gboolean protocoll_process_locked(PacketNode *pkt);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __PROTOCOL_H__
