/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "singit/macros.h"
#include "singit/control.h"
#include "singit/displayer_plugin.h"

#include "displayer_clist_config.h"
#include "displayer_clist_status.h"
#include "displayer_clist.h"

extern DisplayerPlugin clist_dp;
extern GtkWidget *displayer_clist_win;

static gpointer displayer_clist_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	CListConfigData *clist_config_data = g_malloc(sizeof(CListConfigData));

	clist_config_data->forceGlobals = TRUE;
	clist_config_data->debugEnable = FALSE;

	clist_config_data->lyricFontName = NULL;
	clist_config_data->backgroundColor = NULL;
	clist_config_data->normalTextColor = NULL;
	clist_config_data->normalBarColor = NULL;
	clist_config_data->progressTextColor = NULL;
	clist_config_data->progressBarColor = NULL;

	return clist_config_data;
}

static void displayer_clist_config_free_event
	(SingitConfigGen *scg, CListConfigData *cfg_data, gpointer user_data)
{

	if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }
	if (cfg_data->backgroundColor) { g_free(cfg_data->backgroundColor); }
	if (cfg_data->normalTextColor) { g_free(cfg_data->normalTextColor); }
	if (cfg_data->normalBarColor) { g_free(cfg_data->normalBarColor); }
	if (cfg_data->progressTextColor) { g_free(cfg_data->progressTextColor); }
	if (cfg_data->progressBarColor) { g_free(cfg_data->progressBarColor); }

	g_free(cfg_data);
}

#define GBL_VAR       forceGlobals
#define GBL_SESSION   clist_dp.singit_session
#define CFG_DATA      cfg_data
#define CFG_FILE      cfg_file
#define SECTION      "DisplayerCList"

static void displayer_clist_config_load_event
	(SingitConfigGen *scg, ConfigFile* cfg_file, CListConfigData *cfg_data, gpointer user_data)
{
	READ_CFG_DEF(boolean,forceGlobals,TRUE);

	READ_CFG_DEF_GBL(boolean,hideIfNotFound,hide_if_not_found);
	READ_CFG_DEF_GBL(boolean,autoResize,auto_resize);
#ifdef CODEDEBUG
	READ_CFG_DEF_GBL(boolean,debugEnable,debug_enabled);
#endif

	READ_CFG_DEF_GBL(string,lyricFontName,lyric_font_name);

	READ_CFG_DEF_GBL_ARG(color,backgroundColor,color,0);
	READ_CFG_DEF_GBL_ARG(color,normalTextColor,color,1);
	READ_CFG_DEF_GBL_ARG(color,normalBarColor,color,2);
	READ_CFG_DEF_GBL_ARG(color,progressTextColor,color,3);
	READ_CFG_DEF_GBL_ARG(color,progressBarColor,color,4);

	// * global independant config *
	READ_CFG_DEF(boolean,showOnText,TRUE);

	READ_CFG_DEF(int,winPosX,-1);
	READ_CFG_DEF(int,winPosY,-1);

	// * global config copies *
	cfg_data->gblToggleYZ =
		singit_remote_cfg_toggle_yz(clist_dp.singit_session);
}

static void displayer_clist_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, CListConfigData *cfg_data, gpointer user_data)
{
	// * boolean values *
	WRITE_CFG(boolean, forceGlobals);
	WRITE_CFG(boolean, hideIfNotFound);
	WRITE_CFG(boolean, autoResize);
#ifdef CODEDEBUG
	WRITE_CFG(boolean, debugEnable);
#endif

	// * string values *
	WRITE_CFG(del_string, lyricFontName);
	WRITE_CFG(del_string, backgroundColor);
	WRITE_CFG(del_string, normalTextColor);
	WRITE_CFG(del_string, normalBarColor);
	WRITE_CFG(del_string, progressTextColor);
	WRITE_CFG(del_string, progressBarColor);

	// * global independant config *
	WRITE_CFG(boolean, showOnText);

	WRITE_CFG(int, winPosX);
	WRITE_CFG(int, winPosY);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA
#undef GBL_SESSION
#undef GBL_VAR

#define CTRL_SESSION	clist_dp.singit_session
#define CTRL_CFG_DATA	ccd

static void displayer_clist_config_update_event(SingitConfigGen *scg)
{
	CListConfigData *ccd;

	g_return_if_fail(scg != NULL);

	ccd = singit_config_gen_get_data(scg);

	REMOTE_CFG_V(toggle_yz, gblToggleYZ);

	if (ccd->forceGlobals == TRUE) {
		REMOTE_CFG_V(auto_resize, autoResize);
		REMOTE_CFG_V(debug_enabled, debugEnable);
	}

	clist_displayer_real_update(ccd);
}

#undef CTRL_CFG_DATA
#undef CTRL_SESSION

SingitConfigGen* displayer_clist_config_new(void)
{
	g_return_val_if_fail(STATUS != NULL, NULL);
	g_return_val_if_fail(STATUS->config == NULL,
		SINGIT_CONFIG_GEN(STATUS->config));

	STATUS->config = singit_config_xmms_new();
	singit_config_gen_clear_initial(&STATUS->config);
	singit_config_gen_set_filename
		(STATUS->config, CONFIG_FILENAME);

	gtk_signal_connect(GTK_OBJECT(STATUS->config), "init_data",
		GTK_SIGNAL_FUNC(displayer_clist_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "free_data",
		GTK_SIGNAL_FUNC(displayer_clist_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "load",
		GTK_SIGNAL_FUNC(displayer_clist_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "save",
		GTK_SIGNAL_FUNC(displayer_clist_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "update",
		GTK_SIGNAL_FUNC(displayer_clist_config_update_event), NULL);

	return STATUS->config;
}
