/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_clist_status.h"
#include "displayer_clist_config.h"

// Since the clist is a singleton, keep this global static object
static SingitSingleton       *clist_status = NULL;
static SingitSingletonClass  *parent_class = NULL;

static void clist_status_class_init (ClistStatusClass *klass);
static void clist_status_init (ClistStatus *sstat);
static void clist_status_destroy(GtkObject *object);
static gboolean clist_status_after_init(SingitSingleton *single);

GtkType clist_status_get_type (void)
{
	static GtkType clist_status_type = 0;

	if (!clist_status_type) {

		static const GtkTypeInfo clist_status_info =
		{
			(gchar*) "ClistStatus",
			sizeof (ClistStatus),
			sizeof (ClistStatusClass),
			(GtkClassInitFunc) clist_status_class_init,
			(GtkObjectInitFunc) clist_status_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		clist_status_type = gtk_type_from_name("ClistStatus");
		if ((clist_status_type == GTK_TYPE_NONE) ||
			(clist_status_type == GTK_TYPE_INVALID))
		{
			clist_status_type = gtk_type_unique
				(TYPE_SINGIT_SINGLETON, &clist_status_info);
		}
		else { parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON); }
	}

	return clist_status_type;
}

static void clist_status_class_init (ClistStatusClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	SingitSingletonClass *singleton_class =
		(SingitSingletonClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON);

	object_class->destroy = clist_status_destroy;
	singleton_class->after_init = clist_status_after_init;
}

static void clist_status_init(ClistStatus *sstat)
{
	sstat->lastRow = -1;
	sstat->line = -1;
	sstat->jump_to_song = 0;

	sstat->timestamp_context_id = 0;
	sstat->song_context_id = 0;
	sstat->messageCounter = 0;

	sstat->next_lyric_line = NULL;
	sstat->song = NULL;

	sstat->win_size_y = -1;

	sstat->config = NULL;
}

static void clist_status_destroy(GtkObject *object)
{
	ClistStatus *sstat;

	g_return_if_fail(object != NULL);
	g_return_if_fail(IS_CLIST_STATUS (object));

	sstat = CLIST_STATUS(object);

	singit_song_detach(&sstat->song);

	singit_config_gen_detach(&sstat->config);

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

static gboolean clist_status_after_init(SingitSingleton *single)
{
	g_return_val_if_fail(single != NULL, FALSE);
	g_return_val_if_fail(IS_CLIST_STATUS(single), FALSE);

	CLIST_STATUS(single)->config =
		displayer_clist_config_new();
	singit_config_gen_load(CLIST_STATUS(single)->config);

	return (CLIST_STATUS(single)->config != NULL);
}

SingitSingleton* clist_status_ref(void)
{
	gboolean init;
	SingitSingleton *status = singit_singleton_construct
		(&clist_status, TYPE_CLIST_STATUS, &init);
	if (init == TRUE)
		{ return status; }
	return singit_singleton_attach(status);
}

void clist_status_unref(SingitSingleton** single)
{
	g_return_if_fail(clist_status != NULL);

	if (single == NULL) {
		SingitSingleton* unref_single = clist_status;
		singit_singleton_detach(&unref_single);
	}
	else {
		g_return_if_fail(*single == clist_status);
		singit_singleton_detach(single);
	}
}

SingitSingleton* clist_status_noref(void)
{
	if (clist_status == NULL)
		{ return NULL; }

	g_return_val_if_fail(IS_CLIST_STATUS(clist_status), NULL);

	return clist_status;
}
