/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CLEVELPARTICLEENGINE_H__
#define __CLEVELPARTICLEENGINE_H__

#include <glib.h>
#include <GL/gl.h>

#include "ctexture.h"

class CLevelParticleEngine {
protected:
	GSList *active_particles; // Stores the active particle data
	GSList *free_particles; // Stores the unused particle data
	guint list_length, max_level_particles;
	gdouble scaler;
	gdouble speed;
	CTexture *texture;
	gfloat level[3];

	static GLfloat height_scale;

	gdouble calc_level(gint16 freq_data[256]);

public:
	CLevelParticleEngine(guint max_level_part = 20);
	virtual ~CLevelParticleEngine();

	void calc(gint16 data[2][256], gfloat *level);
	void draw(bool beat = false);
	void setTexture(CTexture *texture)
	{
		this->texture = texture;
	}
};

#endif // __CLEVELPARTICLEENGINE_H__
