
#ifndef __SOUND_INPUT_PORT_H__
#define __SOUND_INPUT_PORT_H__

#include "Eg Common.h"

#include "FourierAnalyzer.h"
#include "UtilStr.h"
#include "CEgErr.h"


#if EG_MAC
#include <Sound.h>
pascal void		MyRecInterrupt( SPB* inPB, short* buf, long peak, long size );
#endif

#if EG_WIN
#ifndef WIN_QUICKTIME_PRESENT
typedef long Fixed;
typedef long OSType;
typedef long OSErr;
#endif

typedef WAVEFORMATEX SPB;
#endif

#if EG_POSIX
typedef long Fixed;
typedef long OSType;
typedef long OSErr;
typedef void* SPB;
#endif


/*
enum InputSampleRate {

	SI_44kHz,
	SI_22kHz,
	SI_11kHz,
};*/


//Keep track of the info needed to record
typedef struct _SoundInputRec {
	SPB			recordRec;
	Fixed			sampleRate;
	OSType			compression;
	long			mNumSampleSkip;
	long			myA5,
				devBuffer,
				soundRefNum;
	short			numChannels,
				sampleSize;
	long			mBufEnd;
	long			mDimSamples;
	short*			mSamples;
	long			mBufRemainder;
}
SoundInputRec;


class SoundInput {

public:
	SoundInput();
	virtual	~SoundInput();

	// How we turn the port on and off.  Call StartRecording() before you make calls to GetSamples() or GetSpectrum()
	OSErr					StartRecording();
	void					StopRecording();

	// Retrieves a sound clip, filling inF[], scaling each value by inScale
	// Returns false if the data was not returned
	bool 					GetSamples( short outSamples[], long inN );
	bool					GetSamples( float outSamples[], long inN, float inScale );

	// Tells the sound input how many samples are thrown away per sample taken.  The default value is 0.
	void					SetSampleSkip( long inNumSamples )						{ mParams.mNumSampleSkip = inNumSamples;		}

	// Retrieves a sound clip from the sound in and performs a fourier transform to get a freq spectrum.
	// See FourierAnalyzer.h for a description of the params.
	// Returns false if the data was not returned
	bool 					GetSpectrum( long inBins, float inBinRange, float inFreqStart, float outFT[] );

protected:
	FourierAnalyzer			mAnalyzer;
	UtilStr					mParamBuf;
	SoundInputRec			mParams;
	bool					mIsRecording;

#if EG_WIN
	WAVEHDR					mHdr1, mHdr2;
	HWAVEIN					mWaveDevice;
#endif

	void					DimBufSize( long inNumSamples );
};


#endif // __SOUND_INPUT_PORT_H__
