
#ifndef __EG_COMMON_H__
#define __EG_COMMON_H__

#include <glib.h>

#include "libmfl.h"

#ifndef WORDS_BIGENDIAN
#define MCC4_TO_INT(str) \
	((str[0] << 24) + (str[1] << 16) + (str[2] << 8) + str[3])

#define MCC3_TO_INT(str) \
	((str[0] << 16) + (str[1] << 8) + str[2])

#define MCC2_TO_INT(str) \
	((str[0] << 8) + str[1])
#else
#define MCC4_TO_INT(str) \
	((str[3] << 24) + (str[2] << 16) + (str[1] << 8) + str[0])

#define MCC3_TO_INT(str) \
	((str[2] << 16) + (str[1] << 8) + str[0])

#define MCC2_TO_INT(str) \
	((str[1] << 8) + str[0])
#endif

#ifndef true
#define false 0
#define true !false
#endif

struct Rect {
	short left, top, right, bottom;
};
#define Rect_Defined

typedef long KeyMap[4];

struct Point {
	short v, h;
};

struct RGBColor {
	unsigned short red, green, blue;
};

typedef void *		PixMapHandle;
typedef void *			GrafPtr;
typedef void *			CGrafPtr;
typedef void *		WindowPtr;
typedef mfl_context		GWorldPtr;
typedef void *			BitMap;

struct ColorSpec {
	short		value;
	RGBColor	rgb;
};

struct LongRect {
	long left, top, right, bottom;
};

#endif // __EG_COMMON_H__
