
#define dstmesh  (&(sp->im_mesh[MAX_WINS + 1]))

/* color for selected points */
extern GdkGC   *mps_gc;
/* color for resulting points */
extern GdkGC   *mpr_gc;
/* color for mesh lines */
extern GdkGC *mpl_gc;

void allocate_colors(GtkWidget * widget);




void
flash_point(GdkDrawable  *drawable,
	    int x,int y	    );

void
destroy_image_win_data(int lp);

void
alloc_image_win_data(int lp);

void
create_and_show_image_win(int lp);

void
init_image_win_data_and_set_all(int lp, /* the slot where the data are put
					   in the arrays in sp-> */
				GtkWidget * topw, /* the top window */
				char * name);


void
editview_callback(int i);

void
set_editshow(int lp, /* window number */
	     int status);



void
pixbuf_to_rrrgggbb(GdkPixbuf *pb, guint8 *r, guint8 *g, guint8 *b);


void
rrrgggbbb_add_to_pixbuf(GdkPixbuf *pb, /* destination */
			const guint8 *r, const  guint8 *g, const guint8 *b,
			/* source */
			double factor /* dissolving factor */
			);

void
do_warp_an_image(int lp, char * r, char *g, char * b);


/**********   showerr()
 *  shows libc error 
 */

inline  void 
showerr(char *file, char *msg);


/**********************************************************
 * accepts new backing pixmap of the appropriate size 
 *  save it in the data of the top window 
 * and in the sp-> structure
 * resizes the viewport
*/

gboolean
set_backing_pixmap        (GtkWidget       *widget,
		   GdkPixmap *newpixmap,
		   int width, int height);



/********************************************************************
		loads image from pixbuf to pixmap for image window "lp"
		you should unref the pixbuf   when it exists
		
		copies its data to r,g,b,
*/


void scale_loaded_pixbuf_to_pixmap_et_rrggbb(
		 GdkPixbuf      *impixold,
		 int lp //image number
		 );



/* load/save hooks  */ 

typedef gboolean (*fileselection_hook_t)      (int lp,  char *file);

gboolean load_image_from_file(int lp,
			      char *file);

gboolean save_image_to_file(int lp,
			    char *file);

gboolean save_mesh_to_file(int lp, char * file);

gboolean load_mesh_from_file(int lp, char * file);




/****************************************************************************
 promote meshes to have same lines and columns 
***************************************************************************/

void promote_meshes();
/***********************************************************************
 which image are we displaying? 

   */
#define PIXLOADED 0 
#define PIXSUBIMAGE 1
#define PIXWARPED 2

GdkPixbuf **
which_pixbuf_is_visible(int lp);

GdkPixmap **
which_pixmap_is_visible(int lp);

GdkPixbuf **
which_pixbuf(int lp, int what);

GdkPixmap **
which_pixmap(int lp, int what);

static inline void
which_pixbuf_size(int lp, int what, int *w, int *h)
{
  *w=sp->resulting_width; *h=sp->resulting_height;
  if(what == PIXLOADED)
    { *w=sp->im_width[lp] ;  *h=sp->im_height[lp]; }
}


void
create_pixbuf(int lp, int what);

void
create_pixmap_(int lp, int what);

static inline void
which_pixbuf_size_is_visible(int lp, int *w, int *h)
{
  which_pixbuf_size( lp,sp->which_pix[lp] , w, h);
}


void 
render_pixmap(int lp, int what);

/***************************************************************

 *		drawing area bookkeeping

 ***********************************************************
*/ 


/* creates new backing pixmap of the appropriate size 
   save it in the data of the top window

   it uses: the image filename, to load the image, or, if none
   it creates a black pixmap

   it sets what is necessary for properly displaying the
   drawing area*/


void
drawingarea_configure (int i);

void
reload_and_scale_image(int i);

/************************************


setup_handlebox_factors()

if there is only one image , then we may only warp it
so the handlebox is hidden

otherwise they are shown, and the user may set the factors and warp the image

***********************************/

void
setup_handlebox_factors();
