
#include "stdio.h"

#include "../libmorph/mesh.h"

#define SMOOTH_ITERATIONS 20

void smooth_mesh(MeshT *mesh)
{  
  int xi, yi;
  double x,y;

  int lp;
  for(lp =SMOOTH_ITERATIONS ; lp ; lp--) {
    for(xi=0; xi < mesh->nx ; xi++) {      	
	for(yi=0; yi<mesh->ny  ; yi++) {
	  if( 0 ==  meshGetLabel(mesh,xi,yi)) {	  
	    if ( xi == 0 || xi == mesh->nx -1)
	      x=meshGetx(mesh, xi,yi);
	    else
	      x=(meshGetxRefl(mesh, xi+1,yi) +
		 meshGetxRefl(mesh, xi,yi+1) +
		 meshGetxRefl(mesh, xi-1,yi) +
		 meshGetxRefl(mesh, xi,yi-1)) / 4.0 ; 
	    if ( yi == 0 || yi == mesh->ny -1)
	      y=meshGety(mesh, xi,yi);
	    else
	      y=(meshGetyRefl(mesh, xi+1,yi) +
		 meshGetyRefl(mesh, xi,yi+1) +
		 meshGetyRefl(mesh, xi-1,yi) +
		 meshGetyRefl(mesh, xi,yi-1)) / 4.0 ;
	    meshSetNoundo(mesh,xi,yi,x,y);
	  }
	}
      }
  }
}
