/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/static_routes_base.cc,v 1.21 2009/01/05 18:31:15 jtc Exp $"


#include "static_routes_base.hh"


XrlStaticRoutesTargetBase::XrlStaticRoutesTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlStaticRoutesTargetBase::~XrlStaticRoutesTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlStaticRoutesTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get(0, "target_class").text(),
	    xa_inputs.get(1, "target_instance").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get(0, "target_class").text(),
	    xa_inputs.get(1, "target_instance").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_policy_backend_0_1_configure(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/configure");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_configure(
	    xa_inputs.get(0, "filter").uint32(),
	    xa_inputs.get(1, "conf").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/configure", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_policy_backend_0_1_reset(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/reset");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_reset(
	    xa_inputs.get(0, "filter").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/reset", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_policy_backend_0_1_push_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/push_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_push_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/push_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_enable_static_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/enable_static_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_enable_static_routes(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/enable_static_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_start_static_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/start_static_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_start_static_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/start_static_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_stop_static_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/stop_static_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_stop_static_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/stop_static_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_backup_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_backup_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_backup_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_backup_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_backup_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_backup_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_backup_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_backup_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_backup_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_backup_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_backup_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_backup_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_backup_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_backup_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_backup_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_backup_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_backup_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_backup_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_interface_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_interface_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_interface_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_interface_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_interface_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_interface_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_backup_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_backup_interface_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_backup_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/add_backup_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_add_backup_interface_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/add_backup_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_backup_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_backup_interface_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_backup_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/replace_backup_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_replace_backup_interface_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text(),
	    xa_inputs.get(6, "metric").uint32());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/replace_backup_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_interface_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_backup_interface_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_backup_interface_route4(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv4net(),
	    xa_inputs.get(3, "nexthop").ipv4(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_backup_interface_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_interface_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/delete_backup_interface_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_delete_backup_interface_route6(
	    xa_inputs.get(0, "unicast").boolean(),
	    xa_inputs.get(1, "multicast").boolean(),
	    xa_inputs.get(2, "network").ipv6net(),
	    xa_inputs.get(3, "nexthop").ipv6(),
	    xa_inputs.get(4, "ifname").text(),
	    xa_inputs.get(5, "vifname").text());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/delete_backup_interface_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlStaticRoutesTargetBase::handle_static_routes_0_1_enable_log_trace_all(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "static_routes/0.1/enable_log_trace_all");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = static_routes_0_1_enable_log_trace_all(
	    xa_inputs.get(0, "enable").boolean());
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "static_routes/0.1/enable_log_trace_all", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

void
XrlStaticRoutesTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlStaticRoutesTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlStaticRoutesTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlStaticRoutesTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlStaticRoutesTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlStaticRoutesTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlStaticRoutesTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("policy_backend/0.1/configure",
	    callback(this, &XrlStaticRoutesTargetBase::handle_policy_backend_0_1_configure)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "policy_backend/0.1/configure");
	}
	if (_cmds->add_handler("policy_backend/0.1/reset",
	    callback(this, &XrlStaticRoutesTargetBase::handle_policy_backend_0_1_reset)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "policy_backend/0.1/reset");
	}
	if (_cmds->add_handler("policy_backend/0.1/push_routes",
	    callback(this, &XrlStaticRoutesTargetBase::handle_policy_backend_0_1_push_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "policy_backend/0.1/push_routes");
	}
	if (_cmds->add_handler("static_routes/0.1/enable_static_routes",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_enable_static_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/enable_static_routes");
	}
	if (_cmds->add_handler("static_routes/0.1/start_static_routes",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_start_static_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/start_static_routes");
	}
	if (_cmds->add_handler("static_routes/0.1/stop_static_routes",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_stop_static_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/stop_static_routes");
	}
	if (_cmds->add_handler("static_routes/0.1/add_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/add_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/add_backup_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_backup_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/add_backup_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_backup_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_backup_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_backup_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_backup_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_backup_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_backup_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_backup_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_backup_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_backup_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/add_interface_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_interface_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/add_interface_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_interface_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_interface_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_interface_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_interface_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_interface_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_interface_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_interface_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_interface_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_interface_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/add_backup_interface_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_backup_interface_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/add_backup_interface_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_add_backup_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/add_backup_interface_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_backup_interface_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_backup_interface_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/replace_backup_interface_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_replace_backup_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/replace_backup_interface_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_backup_interface_route4",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_interface_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_backup_interface_route4");
	}
	if (_cmds->add_handler("static_routes/0.1/delete_backup_interface_route6",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_delete_backup_interface_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/delete_backup_interface_route6");
	}
	if (_cmds->add_handler("static_routes/0.1/enable_log_trace_all",
	    callback(this, &XrlStaticRoutesTargetBase::handle_static_routes_0_1_enable_log_trace_all)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "static_routes", "static_routes/0.1/enable_log_trace_all");
	}
	_cmds->finalize();
}

void
XrlStaticRoutesTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("policy_backend/0.1/configure");
	_cmds->remove_handler("policy_backend/0.1/reset");
	_cmds->remove_handler("policy_backend/0.1/push_routes");
	_cmds->remove_handler("static_routes/0.1/enable_static_routes");
	_cmds->remove_handler("static_routes/0.1/start_static_routes");
	_cmds->remove_handler("static_routes/0.1/stop_static_routes");
	_cmds->remove_handler("static_routes/0.1/add_route4");
	_cmds->remove_handler("static_routes/0.1/add_route6");
	_cmds->remove_handler("static_routes/0.1/replace_route4");
	_cmds->remove_handler("static_routes/0.1/replace_route6");
	_cmds->remove_handler("static_routes/0.1/delete_route4");
	_cmds->remove_handler("static_routes/0.1/delete_route6");
	_cmds->remove_handler("static_routes/0.1/add_backup_route4");
	_cmds->remove_handler("static_routes/0.1/add_backup_route6");
	_cmds->remove_handler("static_routes/0.1/replace_backup_route4");
	_cmds->remove_handler("static_routes/0.1/replace_backup_route6");
	_cmds->remove_handler("static_routes/0.1/delete_backup_route4");
	_cmds->remove_handler("static_routes/0.1/delete_backup_route6");
	_cmds->remove_handler("static_routes/0.1/add_interface_route4");
	_cmds->remove_handler("static_routes/0.1/add_interface_route6");
	_cmds->remove_handler("static_routes/0.1/replace_interface_route4");
	_cmds->remove_handler("static_routes/0.1/replace_interface_route6");
	_cmds->remove_handler("static_routes/0.1/delete_interface_route4");
	_cmds->remove_handler("static_routes/0.1/delete_interface_route6");
	_cmds->remove_handler("static_routes/0.1/add_backup_interface_route4");
	_cmds->remove_handler("static_routes/0.1/add_backup_interface_route6");
	_cmds->remove_handler("static_routes/0.1/replace_backup_interface_route4");
	_cmds->remove_handler("static_routes/0.1/replace_backup_interface_route6");
	_cmds->remove_handler("static_routes/0.1/delete_backup_interface_route4");
	_cmds->remove_handler("static_routes/0.1/delete_backup_interface_route6");
	_cmds->remove_handler("static_routes/0.1/enable_log_trace_all");
}
