/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIODRIVERALSA_H
#define AUDIODRIVERALSA_H

#include "AudioBase.h"
#include <alsa/asoundlib.h>

class AudioDriverALSA : public AudioBase
{

 public:  // --------------------------------------------------------- public
	AudioDriverALSA();
	~AudioDriverALSA();
	bool open(const AudioConfig&);
	void close();
	void unload();
	void play(void* buffer, unsigned long int bufferSize);
	bool reset();
	
    const char* getName() const
    {
        return "ALSA";
    }
  private:
    bool haveStream;
    snd_pcm_t * _audioHandle;
    int _alsa_to_frames_divisor;

    void outOfOrder();
};

#endif  // AUDIODRIVERALSA_H

