Captures and holds incoming TCP connections using no local per-connection
resources.
.PP
TARPIT only works at the TCP level, and is totally application agnostic. This
module will answer a TCP request and play along like a listening server, but
aside from sending an ACK or RST, no data is sent. Incoming packets are ignored
and dropped. The attacker will terminate the session eventually. This module
allows the initial packets of an attack to be captured by other software for
inspection. In most cases this is sufficient to determine the nature of the
attack.
.PP
This offers similar functionality to LaBrea
<http://www.hackbusters.net/LaBrea/> but does not require dedicated hardware or
IPs. Any TCP port that you would normally DROP or REJECT can instead become a
tarpit.
.TP
\fB\-\-tarpit\fP
This mode completes a connection with the attacker but limits the window size
to 0, thus keeping the attacker waiting long periods of time. While he is
maintaining state of the connection and trying to continue every 60-240
seconds, we keep none, so it is very lightweight. Attempts to close the
connection are ignored, forcing the remote side to time out the connection in
12-24 minutes. This mode is the default.
.TP
\fB\-\-honeypot\fP
This mode completes a connection with the attacker, but signals a normal window
size, so that the remote side will attempt to send data, often with some very
nasty exploit attempts. We can capture these packets for decoding and further
analysis. The module does not send any data, so if the remote expects an
application level response, the game is up.
.TP
\fB\-\-reset\fP
This mode is handy because we can send an inline RST (reset). It has no other
function.
.PP
To tarpit connections to TCP port 80 destined for the current machine:
.IP
\-A INPUT \-p tcp \-m tcp \-\-dport 80 \-j TARPIT
.PP
To significantly slow down Code Red/Nimda-style scans of unused address space,
forward unused ip addresses to a Linux box not acting as a router (e.g. "ip
route 10.0.0.0 255.0.0.0 ip.of.linux.box" on a Cisco), enable IP forwarding on
the Linux box, and add:
.IP
\-A FORWARD \-p tcp \-j TARPIT
.IP
\-A FORWARD \-j DROP
.PP
NOTE:
If you use the conntrack module while you are using TARPIT, you should also use
unset tracking on the packet, or the kernel will unnecessarily allocate
resources for each TARPITted connection. To TARPIT incoming connections to the
standard IRC port while using conntrack, you could:
.IP
\-t raw \-A PREROUTING \-p tcp \-\-dport 6667 \-j CT \-\-notrack
.IP
\-A INPUT \-p tcp \-\-dport 6667 \-j NFLOG
.IP
\-A INPUT \-p tcp \-\-dport 6667 \-j TARPIT
