/* xtermset: change some settings of an xterm from the command line */

/* this was orginally 'setxtitle' in the splitvt package,
 * created by Sam Lantinga(slouken@cs.ucdavis.edu)
 * rewritten by Breyten Ernsting (bje@dds.nl)
 * and again by Decklin Foster (decklin@home.com) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define VERSION		"0.4"
#define ESC		"\033"
#define BEL		"\07"
#define BasicOption	1
#define ShortOption	2
#define GeomOption	3
#define UnknownOption	4
#define SwitchOption	5

#define OPTION(name, code, style) \
if (strcmp(arg, "-" name) == 0) { *code_return = code; return style; } 

#define CHECK if((is_good_term())||(switches[0]))

void usage();
int nextopt();
void set_geom();
int is_good_term(); // 1 if good terminal

int main(int argc, char *argv[])
{
    int i, code, switches[0];
    
	/*
    if(argc<2) {
	usage();
	exit(1);
    } */

    for (i=1; i<argc; i++) {
	switch (nextopt(argv[i], &code)) {
	    case BasicOption:
		if (i + 1 < argc) {
		    i++;
		    CHECK {
			printf(ESC "]%d;%s" BEL, code, argv[i]); 
		    }
		} 
		break;
	    case GeomOption:
		if(i + 1 < argc) {
		    i++;
		    CHECK {
		        set_geom(argv[i]); 
		    }
		}
		break;
	    case ShortOption:
		CHECK {
		    printf(ESC "[%dt", code); }
		break;
	    case SwitchOption:
		switches[code]=1; break;
	    case UnknownOption:
		usage();
		exit(2);
	}
    }
    exit(0);
}

void usage()
{
    printf("xtermset version " VERSION " - options:\n");
    printf("  [-force|f] [-title|T window-title] [-n icon-name]\n");
    printf("  [-fg color] [-bg color] [-cr color]\n");
    printf("  [-mousefg color] [-mousebg color]\n");
    printf("  [-tekfg color] [-tekbg color] [-hc color]\n");
    printf("  [-fn|font font-spec] [-geom size-spec]\n");
    printf("  [-iconify] [-restore] [-refresh]\n");
}

int nextopt(char *arg, int *code_return)
{
    OPTION("title", 2, BasicOption)
    OPTION("T", 2, BasicOption)
    OPTION("n", 1, BasicOption)
    OPTION("fg", 10, BasicOption)
    OPTION("bg", 11, BasicOption)
    OPTION("cr", 12, BasicOption)
    OPTION("mousefg", 13, BasicOption)
    OPTION("mousebg", 14, BasicOption)
    OPTION("tekfg", 15, BasicOption)
    OPTION("tekbg", 16, BasicOption)
    OPTION("hc", 17, BasicOption)
    OPTION("font", 50, BasicOption)
    OPTION("fn", 50, BasicOption)
    OPTION("geom", -1, GeomOption)
    OPTION("geometry", -1, GeomOption)
    OPTION("iconify", 2, ShortOption)
    OPTION("restore", 1, ShortOption)
    OPTION("refresh", 7, ShortOption)
    OPTION("force",0, SwitchOption)
    OPTION("f",0,SwitchOption)
    return UnknownOption;
}

void set_geom(char *geometry)
{
    char *x, *y, *width, *height;

    if (strncmp(geometry, "+", 1) == 0) {
	x = strtok(geometry, "+");
	y = strtok(NULL, "");
	printf(ESC "[3;%s;%st", x, y);
    } else {
	width = strtok(geometry, "x");
	height = strtok(NULL, "+");
	printf(ESC "[8;%s;%st", height, width);
	if ((x = strtok(NULL, "+"))) {
	    y = strtok(NULL, "");
	    printf(ESC "[3;%s;%st", x, y);
	}
    }
}

int is_good_term()
{
    if(strncmp(getenv("TERM"),"xterm",5)==0) {
	return 1;
    } else if (strncmp(getenv("TERM"),"dtterm",6)==0) {
	return 1;
    }
    return 0;
}
