#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netdb.h>	/* For gethostbyname(). */
extern int h_errno;

#include <netinet/in.h>

#include "../include/Y2/Y.h"
#include "../include/Y2/Ylib.h"

#include "../include/string.h"


static void print_help(void);


#define MIN(a,b)        ((a) < (b) ? (a) : (b))
#define MAX(a,b)        ((a) > (b) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define ABSOLUTE(x)     (((x) < 0) ? ((x) * -1) : (x))


/*
 *	Prints help message.
 */
static void print_help(void)
{
	printf("\
Usage: yhost [-] <address> [options]\n\
\n\
    Specifying a `-' argument means to remove the <address>.\n\
\n\
    <address> is the numeric IP or named address of the host you\n\
    want to allow/disallow access to the Y server.\n\
    This command must be runned on the same physical computer as\n\
    the Y server is running on.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --recorder <address:port>    Specify which Y server to connect to.\n\
\n\
    Return values:\n\
\n\
        0       Success.\n\
        1       General error.\n\
        2       Cannot connect to Y server error.\n\
        3       Systems error.\n\
\n"
	);
}


int main(int argc, char *argv[])
{
	int i, status;
	const char *arg_ptr;

	const char *con_arg = NULL;
	Boolean is_add_host = True;

	YConnection *con = NULL;
	YIPUnion ip;

	struct hostent *he;
        struct sockaddr_in haddr;


	if(argc < 2)
	{
	    print_help();
	    return(1);
	}


	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    arg_ptr = argv[i];
	    if(arg_ptr == NULL)
		continue;

	    /* Help. */
	    if(strcasepfx(arg_ptr, "--h") ||
               strcasepfx(arg_ptr, "-h") ||
               !strcmp(arg_ptr, "?")
	    )
	    {
		print_help();
		return(0);
	    }
            /* Connect address. */
            if(strcasepfx(arg_ptr, "--rec") ||
               strcasepfx(arg_ptr, "-rec")
            )
            {
                i++;
		arg_ptr = (i < argc) ? argv[i] : NULL;
		if(arg_ptr != NULL)
                {
                    con_arg = arg_ptr;
                }
                else
                {
                    fprintf(
			stderr,
                        "%s: Requires argument.\n",
                        argv[i - 1]
                    );
		    continue;
                }
            }
	    /* Add or remove? */
	    if(i == 1)
	    {
		if(!strcmp(arg_ptr, "-"))
		{
		    is_add_host = False;
		    continue;
		}
		else if(!strcmp(arg_ptr, "+"))
		{
		    is_add_host = True;
                    continue;
		}
		else
		{
		    is_add_host = True;
		}
	    }
	    /* Address. */
	    if((i == 1) ||
               (i == 2)
            )
	    {
		/* Parse and resolve address. */
		he = gethostbyname(arg_ptr);
		if(he == NULL)
		{
		    switch(h_errno)
		    {
                      case NO_ADDRESS:
                        fprintf(
			    stderr,
                            "%s: No associated IP address.\n",
                            arg_ptr
                        );
                        break;

                      case NO_RECOVERY:
                        fprintf(
			    stderr,
                            "%s: Unrecoverable error.\n",
                            arg_ptr
                        );
                        break;

                      case TRY_AGAIN:
                        fprintf(
			    stderr,
                            "%s: Name server unavailable.\n",
                            arg_ptr
                        );
                        break;

                      default:
                        fprintf(
			    stderr,
                            "%s: Unknown host.\n",
                            arg_ptr
                        );
                        break;
		    }

		    return(1);
		}

		haddr.sin_addr = *((struct in_addr *)he->h_addr);
		ip.whole = (u_int32_t)haddr.sin_addr.s_addr;

		continue;
	    }
	}


        /* Connect to Y server. */
        con = YOpenConnection(
            NULL,               /* No start argument. */
            con_arg
        );
        if(con == NULL)
        {
            fprintf(stderr, "Cannot connect to Y server");
            if(con_arg == NULL)
                con_arg = getenv("RECORDER");
            if(con_arg == NULL)
                fprintf(stderr, ".\n");
            else
                fprintf(stderr, ": %s\n", con_arg);
            return(2);
        }

	/* Add or remove host? */
	if(is_add_host)
	    status = YAddHost(con, &ip);
	else
	    status = YRemoveHost(con, &ip);

	if(status)
            printf("Cannot %s %i.%i.%i.%i.\n",
		(is_add_host) ? "add" : "remove",
                ip.charaddr[0],
                ip.charaddr[1],
                ip.charaddr[2],
                ip.charaddr[3]
            );
	else
            printf("%s %i.%i.%i.%i %s host access list.\n",
                (is_add_host) ? "Adding" : "Removing",
                ip.charaddr[0],
                ip.charaddr[1],
                ip.charaddr[2],
                ip.charaddr[3],
		(is_add_host) ? "to" : "from"
            );

        /* Disconnect from Y server. */
        YCloseConnection(con, False);
        con = NULL;

	return(0);
}
