#include <windows.h>
#include "userdata.h"
#include "w_option.h"

void mime_encode( unsigned char *sptr, unsigned char *dptr, int pslen );
void mimedecode(char *source,char *dest);
BOOL get_dword_value(HKEY hKey,char *entry,DWORD *retvalue);
BOOL get_str_value(HKEY hKey,char *entry,char *retvalue);

BOOL reg_read_user()
{
	BOOL ret = TRUE;
	HKEY hKey = NULL;
	DWORD value;
	char cv[MAX_PATH];
	char cv2[MAX_PATH];

	/* home key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\user",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return FALSE;
	/* user */
	if( get_str_value(hKey,"username",cv) ){
		set_user_name(cv);
	}else{
		ret = FALSE;
	}
	if( get_str_value(hKey,"servername",cv) ){
		set_server_name(cv);
	}else{
		ret = FALSE;
	}
	if( get_str_value(hKey,"password",cv) ){
		mimedecode( cv, cv2 );
		set_password(cv2);
	}else{
		ret = FALSE;
	}
	if( get_dword_value(hKey,"auth",&value) ){
		set_auth( (int)value );
	}else{
		ret = FALSE;
	}
	if( get_dword_value(hKey,"head_list",&value) ){
		set_head_list_num( (int)value );
	}else{
		ret = FALSE;
	}
	/* dialog */
	if( get_dword_value(hKey,"dialog",&value) ){
		set_dlg_check( (int)value );
	}else{
		ret = FALSE;
	}
	RegCloseKey(hKey);
	return ret;
}

BOOL reg_read_win_pos(int *left, int *top)
{
	BOOL ret = TRUE;
	HKEY hKey = NULL;
	DWORD value;

	/* open key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\window",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return FALSE;
	/* window */
	if( get_dword_value(hKey,"left",&value) ){
		*left = (int)value;
	}else{
		ret = FALSE;
	}
	if(	get_dword_value(hKey,"top",&value) ){
		*top = (int)value;
	}else{
		ret = FALSE;
	}
	RegCloseKey(hKey);
	return ret;
}

BOOL reg_read_win_disp(int *disp,int *disp_top)
{
	BOOL ret = TRUE;
	HKEY hKey = NULL;
	DWORD value;

	/* open key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\window",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return FALSE;
	if( get_dword_value(hKey,"disp",&value) ){
		*disp = (int)value;
	}else{
		ret = FALSE;
	}
	if( get_dword_value(hKey,"disp_top",&value) ){
		*disp_top = (int)value;
	}else{
		ret = FALSE;
	}
	RegCloseKey(hKey);
	return ret;
}

BOOL reg_read_option()
{
	BOOL ret = TRUE;
	HKEY hKey = NULL;
	DWORD value;
	char cv[MAX_PATH];

	/* open key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\option",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return FALSE;
	/* sound_state */
	if( get_dword_value(hKey,"sound",&value) ){
		set_sound_state(value);
	}else{
		ret = FALSE;
	}
	/* sound_filename */
	if( get_str_value(hKey,"sound_filename",cv) ){
		set_sound_filename(cv);
	}else{
		ret = FALSE;
	}
	/* mess_dlg_open */
	if( get_dword_value(hKey,"mess_dlg_open",&value) ){
		set_message_open(value);
	}else{
		ret = FALSE;
	}
	/* mess_dlg_close */
	if( get_dword_value(hKey,"mess_dlg_close",&value) ){
		set_message_close(value);
	}else{
		ret = FALSE;
	}
	/* disp_second */
	if( get_dword_value(hKey,"disp_second",&value) ){
		set_message_disp_seconds(value);
	}else{
		ret = FALSE;
	}
	/* max_message_num */
	if( get_dword_value(hKey,"max_message_num",&value) ){
		set_max_message_count(value);
	}else{
		ret = FALSE;
	}

	RegCloseKey(hKey);
	return ret;
}

BOOL get_dword_value(HKEY hKey,char *entry,DWORD *retvalue)
{
	DWORD dsize;
	dsize = sizeof(DWORD);
	if( RegQueryValueEx(hKey,entry,NULL,NULL,
			(LPBYTE)retvalue,&dsize) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

BOOL get_str_value(HKEY hKey,char *entry,char *retvalue)
{
	char str[MAX_PATH];
	DWORD dsize;
	dsize = sizeof(str);
	if( RegQueryValueEx(hKey,entry,NULL,NULL,
			(LPBYTE)str,&dsize) != ERROR_SUCCESS )
		return FALSE;
	strcpy(retvalue,str);
	return TRUE;
}

void reg_write_user()
{
	HKEY hKey;
	DWORD value;
	char cv[MAX_PATH];
	char cv2[MAX_PATH];

	/* create or open key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\user",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return;
	/* username */
	get_user_name(cv);
	value = lstrlen(cv);
	RegSetValueEx( hKey, "username",0,REG_SZ,(LPBYTE)cv,value);
	/* servername */
	get_server_name(cv);
	value = lstrlen(cv);
	RegSetValueEx( hKey, "servername",0,REG_SZ,(LPBYTE)cv,value);
	/* password */
	get_password(cv);
	mime_encode( cv, cv2, strlen(cv) );
	strcat(cv2,"\000");
	value = lstrlen(cv2);
	RegSetValueEx( hKey, "password",0,REG_SZ,(LPBYTE)cv2,value);
	/* auth */
	value = (DWORD)check_auth();
	RegSetValueEx( hKey,"auth",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* head_list */
	value = (DWORD)get_head_list_num();
	RegSetValueEx( hKey,"head_list",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* dialog */
	value = (DWORD)get_dlg_check();
	RegSetValueEx( hKey,"dialog",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* close key */
	RegCloseKey(hKey);
}

void reg_write_win_pos(int left,int top)
{
	HKEY hKey;
	DWORD value;
	/* create key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\window",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return;
	/* window left */
	value = (DWORD)left;
	RegSetValueEx( hKey,"left",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* window top */
	value = (DWORD)top;
	RegSetValueEx( hKey,"top",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* close key */
	RegCloseKey(hKey);
}

void reg_write_win_disp(int disp,int disp_top)
{
	HKEY hKey;
	DWORD value;
	/* create key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\window",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return;
	/* disp */
	value = (DWORD)disp;
	RegSetValueEx( hKey,"disp",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* disp */
	value = (DWORD)disp_top;
	RegSetValueEx( hKey,"disp_top",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
	/* close key */
	RegCloseKey(hKey);
}

void reg_write_option()
{
	HKEY hKey;
	DWORD value;
	char cv[MAX_PATH];

	/* open key */
	if( RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Youbin\\option",0,
			KEY_ALL_ACCESS,&hKey) != ERROR_SUCCESS )
		return;

    /* sound */
	value = (DWORD)get_sound_state();
	RegSetValueEx( hKey,"sound",0,REG_DWORD,
					(LPBYTE)&value,sizeof(DWORD) );
    /* sound_filename */
	get_sound_filename(cv);
	value = lstrlen(cv);
	RegSetValueEx( hKey, "sound_filename",0,REG_SZ,(LPBYTE)cv,value);
    /* mess_dlg_open */
	value = (DWORD)get_message_open();
	RegSetValueEx( hKey,"mess_dlg_open",0,REG_DWORD,
				    (LPBYTE)&value,sizeof(DWORD) );
	/* mess_dlg_close */
	value = (DWORD)get_message_close();
	RegSetValueEx( hKey,"mess_dlg_close",0,REG_DWORD,
				    (LPBYTE)&value,sizeof(DWORD) );
	/* disp_second */
	value = (DWORD)get_message_disp_seconds();
	RegSetValueEx( hKey,"disp_second",0,REG_DWORD,
				    (LPBYTE)&value,sizeof(DWORD) );
    /* max_message_num */
	value = (DWORD)get_max_message_count();
	RegSetValueEx( hKey,"max_message_num",0,REG_DWORD,
				    (LPBYTE)&value,sizeof(DWORD) );
	/* close key */
	RegCloseKey(hKey);
}
