/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gui/SKMapDialog.h"

SKMapDialog::SKMapDialog (void) : SDialog (new SKMapPanel())
{
  panel = (SKMapPanel*) dialogPanel;
  recalc();
}

SKMapDialog::~SKMapDialog ()
{
}

bool
SKMapDialog::getInput (const SString& title, 
  const SStringVector& kmapList, int selected)
{
  panel->setList (kmapList, selected);
  setTitle (title);
  recalc();
  return SDialog::getInput (SDialog::SS_OK_CANCEL);
}

void
SKMapDialog::setFont (const SString& font, double fontSize)
{
  panel->setFont (font, fontSize);
  SDialog::setFont (font, fontSize);
}

void
SKMapDialog::setFontSize (double fontSize)
{
  panel->setFontSize (fontSize);
  SDialog::setFontSize (fontSize);
}

void
SKMapDialog::setBackground (const SColor& bg)
{
  SDialog::setBackground (bg);
  panel->setBackground (bg);
}

void
SKMapDialog::setForeground (const SColor& fg)
{
  SDialog::setForeground (fg);
  panel->setForeground (fg);
}

void
SKMapDialog::setTitleForeground (const SColor& fg)
{
  SDialog::setTitleForeground (fg);
  panel->setTitleForeground (fg);
}

void
SKMapDialog::setSliderBackground (const SColor& bg)
{
  panel->setSliderBackground (bg);
}
void
SKMapDialog::setLabelForeground (const SColor& fg)
{
  //SDialog::setLabelForeground (fg);
  panel->setLabelForeground (fg);
}

const SStringVector&
SKMapDialog::getKMapList() const
{
  return panel->getKMapList ();
}

int
SKMapDialog::getSelectedKMap() const
{
  return panel->getSelectedKMap ();
}

