/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef SFontTTF_h
#define SFontTTF_h

#include "swindow/SCanvas.h"
#include "swindow/SPen.h"

#include "stoolkit/SIO.h"
#include "stoolkit/STypes.h"
#include "stoolkit/SMatrix.h"
#include "stoolkit/SBinHashtable.h"
#include "stoolkit/SProperties.h"
#include "stoolkit/SBinVector.h"
#include "stoolkit/SString.h"
#include "stoolkit/SProperties.h"
#include "stoolkit/SUniMap.h"


/**
 * This file will not be exposed so we can put some local junk here.
 */

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 * This is the abstract widget toolkit font package
 */

typedef SS_WORD16 SS_GlyphIndex;
typedef SBinVector<SS_GlyphIndex> SV_GlyphIndex;


class SFontTTF
{
public:
  SFontTTF (const SFile& file, const SString& encoding); 
  virtual ~SFontTTF (); 

  bool draw (SCanvas* canvas, const SS_Matrix2D& matrix, SS_UCS4 uch);
  bool width (const SS_Matrix2D& matrix, SS_UCS4 uch, double* width_);

  double width (const SS_Matrix2D& matrix);
  double ascent (const SS_Matrix2D& matrix);
  double descent (const SS_Matrix2D& matrix);
  double gap (const SS_Matrix2D& matrix);
  /* mulltiply this with size you want to get the matrix */
  double scale ();
  bool isOK();
private:
  SProperties           char2Glyphs;
  SBinHashtable<double> char2Width;

  void drawGlyph (SCanvas* canvas, const SS_Matrix2D& matrix, 
      SS_GlyphIndex glyphno);

  double widthGlyph (const SS_Matrix2D& m, SS_GlyphIndex glyphno);

  bool findGlyphs (SS_UCS4 in, SV_GlyphIndex* out);
  SS_GlyphIndex findGlyph (SS_UCS4 in);

  unsigned int getOTFLigature (const char* script, const char* feature, 
    const SS_GlyphIndex* chars, unsigned int liglen, SS_GlyphIndex* out);

  bool SFontTTF::hasOTFLigatures();

  unsigned int SFontTTF::getOTFLigatures (SS_GlyphIndex* ino, 
   unsigned int len, const char* script, const char* feature, 
   SS_GlyphIndex halant, SS_GlyphIndex reord, bool* base);

  SFileImage image;
  SString name;
  SString fontencoding;

  SFile file;
  bool ok;
  bool broken;

  bool init ();
  bool processName (); 
  bool checkTables ();
  void getName (long id, const char* str, int len);

  SProperties          names;
  SBinHashtable<void*> tables;

  SUniMap              charEncoder;
  unsigned int         charEncoderTable;

  //double  fontSize;
  double  scaleFactor;

  // line height is charAscent - charDescent + lineGap
  double  lineGap;
  double  charWidth;
  double  charAscent;
  double  charDescent;

  //double  scaleFactor;

  double  italicAngle;
  double  underlineThickness;
  double  underlinePosition;
  bool    isFixedPitch;
  int     longOffsets;
};

#endif /* SFontTTF_h */
