/* desktop-launch-listener.c generated by valac 0.14.2, the Vala compiler
 * generated from desktop-launch-listener.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010, 2012 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <zeitgeist.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_DESKTOP_LAUNCH_LISTENER (desktop_launch_listener_get_type ())
#define DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener))
#define DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))
#define IS_DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_LAUNCH_LISTENER))
#define IS_DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_LAUNCH_LISTENER))
#define DESKTOP_LAUNCH_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))

typedef struct _DesktopLaunchListener DesktopLaunchListener;
typedef struct _DesktopLaunchListenerClass DesktopLaunchListenerClass;
typedef struct _DesktopLaunchListenerPrivate DesktopLaunchListenerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _DesktopLaunchListener {
	DataProvider parent_instance;
	DesktopLaunchListenerPrivate * priv;
};

struct _DesktopLaunchListenerClass {
	DataProviderClass parent_class;
};

struct _DesktopLaunchListenerPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GDBusConnection* bus;
	guint launched_signal_id;
};


static gpointer desktop_launch_listener_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType desktop_launch_listener_get_type (void) G_GNUC_CONST;
#define DESKTOP_LAUNCH_LISTENER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerPrivate))
enum  {
	DESKTOP_LAUNCH_LISTENER_DUMMY_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_UNIQUE_ID,
	DESKTOP_LAUNCH_LISTENER_NAME,
	DESKTOP_LAUNCH_LISTENER_DESCRIPTION,
	DESKTOP_LAUNCH_LISTENER_DATAHUB,
	DESKTOP_LAUNCH_LISTENER_ENABLED,
	DESKTOP_LAUNCH_LISTENER_REGISTER
};
DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub);
DesktopLaunchListener* desktop_launch_listener_construct (GType object_type, DataHub* datahub);
static void desktop_launch_listener_real_start (DataProvider* base);
static void desktop_launch_listener_signal_received (DesktopLaunchListener* self, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters);
static void _desktop_launch_listener_signal_received_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
static GHashTable* _variant_get1 (GVariant* value);
gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file, GDesktopAppInfo** dai);
static void _g_object_unref0_ (gpointer var);
static void desktop_launch_listener_real_stop (DataProvider* base);
static GObject * desktop_launch_listener_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_launch_listener_finalize (GObject* obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
DataHub* data_provider_get_datahub (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_desktop_launch_listener_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_desktop_launch_listener_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DesktopLaunchListener* desktop_launch_listener_construct (GType object_type, DataHub* datahub) {
	DesktopLaunchListener * self = NULL;
	DataHub* _tmp0_;
	g_return_val_if_fail (datahub != NULL, NULL);
	_tmp0_ = datahub;
	self = (DesktopLaunchListener*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,gio-launch-listener", "name", "Launched desktop files", "description", "Logs events about launched desktop files using GIO", "datahub", _tmp0_, NULL);
	return self;
}


DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub) {
	return desktop_launch_listener_construct (TYPE_DESKTOP_LAUNCH_LISTENER, datahub);
}


static void _desktop_launch_listener_signal_received_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	desktop_launch_listener_signal_received (self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static void desktop_launch_listener_real_start (DataProvider* base) {
	DesktopLaunchListener * self;
	guint _tmp0_;
	GDBusConnection* _tmp1_;
	guint _tmp2_ = 0U;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->launched_signal_id;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = self->priv->bus;
	_tmp2_ = g_dbus_connection_signal_subscribe (_tmp1_, NULL, "org.gtk.gio.DesktopAppInfo", "Launched", "/org/gtk/gio/DesktopAppInfo", NULL, 0, _desktop_launch_listener_signal_received_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
	self->priv->launched_signal_id = _tmp2_;
}


static GHashTable* _variant_get1 (GVariant* value) {
	GHashTable* _tmp10_;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	_tmp10_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp11_, value);
	while (g_variant_iter_loop (&_tmp11_, "{?*}", &_tmp12_, &_tmp13_)) {
		g_hash_table_insert (_tmp10_, g_variant_dup_string (_tmp12_, NULL), g_variant_get_variant (_tmp13_));
	}
	return _tmp10_;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_launch_listener_signal_received (DesktopLaunchListener* self, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters) {
	GVariant* desktop_variant = NULL;
	GVariantIter* uris = NULL;
	GVariant* dict = NULL;
	gint64 pid = 0LL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* desktop_file;
	const gchar* _tmp4_;
	gchar* uri = NULL;
	GVariant* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp14_;
	GHashTable* extra_params;
	GDesktopAppInfo* dai = NULL;
	const gchar* _tmp15_;
	GDesktopAppInfo* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* launched_uri;
	const gchar* _tmp18_;
	gchar* launcher_uri;
	GHashTable* _tmp20_;
	gconstpointer _tmp21_ = NULL;
	GVariant* origin_df;
	GVariant* _tmp22_;
	GDesktopAppInfo* _tmp38_;
	gboolean _tmp39_ = FALSE;
	ZeitgeistEvent* _tmp40_;
	ZeitgeistEvent* _tmp41_;
	ZeitgeistEvent* event;
	ZeitgeistSubject* _tmp42_;
	ZeitgeistSubject* _tmp43_;
	ZeitgeistSubject* subject;
	ZeitgeistEvent* _tmp44_;
	const gchar* _tmp45_;
	ZeitgeistEvent* _tmp46_;
	ZeitgeistEvent* _tmp47_;
	ZeitgeistEvent* _tmp48_;
	ZeitgeistSubject* _tmp49_;
	ZeitgeistSubject* _tmp50_;
	const gchar* _tmp51_;
	ZeitgeistSubject* _tmp52_;
	ZeitgeistSubject* _tmp53_;
	ZeitgeistSubject* _tmp54_;
	ZeitgeistSubject* _tmp55_;
	GDesktopAppInfo* _tmp56_;
	const gchar* _tmp57_ = NULL;
	GPtrArray* _tmp58_;
	GPtrArray* arr;
	GPtrArray* _tmp59_;
	ZeitgeistEvent* _tmp60_;
	ZeitgeistEvent* _tmp61_;
	GPtrArray* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = parameters;
	g_variant_get (_tmp0_, "(@aysxas@a{sv})", &desktop_variant, NULL, &pid, &uris, &dict, NULL);
	_tmp1_ = desktop_variant;
	_tmp2_ = g_variant_get_bytestring (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	desktop_file = _tmp3_;
	_tmp4_ = desktop_file;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	while (TRUE) {
		GVariantIter* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp5_ = uris;
		_tmp6_ = g_variant_iter_next (_tmp5_, "s", &uri, NULL);
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = uri;
		g_debug ("desktop-launch-listener.vala:103: ran with uri: %s", _tmp7_);
	}
	_tmp8_ = dict;
	_tmp9_ = _variant_get1 (_tmp8_);
	_tmp14_ = _g_hash_table_ref0 (_tmp9_);
	extra_params = _tmp14_;
	_tmp15_ = desktop_file;
	_tmp17_ = utils_get_actor_for_desktop_file (_tmp15_, &_tmp16_);
	_g_object_unref0 (dai);
	dai = _tmp16_;
	launched_uri = _tmp17_;
	_tmp18_ = launched_uri;
	if (_tmp18_ == NULL) {
		const gchar* _tmp19_;
		_tmp19_ = desktop_file;
		g_warning ("desktop-launch-listener.vala:114: Unable to open desktop file '%s'", _tmp19_);
		_g_free0 (launched_uri);
		_g_object_unref0 (dai);
		_g_hash_table_unref0 (extra_params);
		_g_free0 (uri);
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	launcher_uri = NULL;
	_tmp20_ = extra_params;
	_tmp21_ = g_hash_table_lookup (_tmp20_, "origin-desktop-file");
	origin_df = (GVariant*) _tmp21_;
	_tmp22_ = origin_df;
	if (_tmp22_ != NULL) {
		GVariant* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp23_ = origin_df;
		_tmp24_ = g_variant_get_bytestring (_tmp23_);
		_tmp25_ = utils_get_actor_for_desktop_file (_tmp24_, NULL);
		_g_free0 (launcher_uri);
		launcher_uri = _tmp25_;
	} else {
		GHashTable* _tmp26_;
		gconstpointer _tmp27_ = NULL;
		GVariant* origin_prgname;
		GVariant* _tmp28_;
		_tmp26_ = extra_params;
		_tmp27_ = g_hash_table_lookup (_tmp26_, "origin-prgname");
		origin_prgname = (GVariant*) _tmp27_;
		_tmp28_ = origin_prgname;
		if (_tmp28_ != NULL) {
			GVariant* _tmp29_;
			const gchar* _tmp30_ = NULL;
			const gchar* prgname;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* origin_desktop_id;
			const gchar* _tmp33_;
			GDesktopAppInfo* _tmp34_;
			GDesktopAppInfo* id_check;
			GDesktopAppInfo* _tmp35_;
			_tmp29_ = origin_prgname;
			_tmp30_ = g_variant_get_bytestring (_tmp29_);
			prgname = _tmp30_;
			_tmp31_ = prgname;
			_tmp32_ = g_strconcat (_tmp31_, ".desktop", NULL);
			origin_desktop_id = _tmp32_;
			_tmp33_ = origin_desktop_id;
			_tmp34_ = g_desktop_app_info_new (_tmp33_);
			id_check = _tmp34_;
			_tmp35_ = id_check;
			if (_tmp35_ != NULL) {
				const gchar* _tmp36_;
				gchar* _tmp37_ = NULL;
				_tmp36_ = origin_desktop_id;
				_tmp37_ = g_strdup_printf ("application://%s", _tmp36_);
				_g_free0 (launcher_uri);
				launcher_uri = _tmp37_;
			}
			_g_object_unref0 (id_check);
			_g_free0 (origin_desktop_id);
		}
	}
	_tmp38_ = dai;
	_tmp39_ = g_app_info_should_show ((GAppInfo*) _tmp38_);
	if (!_tmp39_) {
		_g_free0 (launcher_uri);
		_g_free0 (launched_uri);
		_g_object_unref0 (dai);
		_g_hash_table_unref0 (extra_params);
		_g_free0 (uri);
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	_tmp40_ = zeitgeist_event_new ();
	_tmp41_ = g_object_ref_sink (_tmp40_);
	event = _tmp41_;
	_tmp42_ = zeitgeist_subject_new ();
	_tmp43_ = g_object_ref_sink (_tmp42_);
	subject = _tmp43_;
	_tmp44_ = event;
	_tmp45_ = launcher_uri;
	zeitgeist_event_set_actor (_tmp44_, _tmp45_);
	_tmp46_ = event;
	zeitgeist_event_set_interpretation (_tmp46_, ZEITGEIST_ZG_ACCESS_EVENT);
	_tmp47_ = event;
	zeitgeist_event_set_manifestation (_tmp47_, ZEITGEIST_ZG_USER_ACTIVITY);
	_tmp48_ = event;
	_tmp49_ = subject;
	zeitgeist_event_add_subject (_tmp48_, _tmp49_);
	_tmp50_ = subject;
	_tmp51_ = launched_uri;
	zeitgeist_subject_set_uri (_tmp50_, _tmp51_);
	_tmp52_ = subject;
	zeitgeist_subject_set_interpretation (_tmp52_, ZEITGEIST_NFO_SOFTWARE);
	_tmp53_ = subject;
	zeitgeist_subject_set_manifestation (_tmp53_, ZEITGEIST_NFO_SOFTWARE_ITEM);
	_tmp54_ = subject;
	zeitgeist_subject_set_mimetype (_tmp54_, "application/x-desktop");
	_tmp55_ = subject;
	_tmp56_ = dai;
	_tmp57_ = g_app_info_get_display_name ((GAppInfo*) _tmp56_);
	zeitgeist_subject_set_text (_tmp55_, _tmp57_);
	_tmp58_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	arr = _tmp58_;
	_tmp59_ = arr;
	_tmp60_ = event;
	_tmp61_ = _g_object_ref0 (_tmp60_);
	g_ptr_array_add (_tmp59_, _tmp61_);
	_tmp62_ = arr;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp62_);
	_g_ptr_array_unref0 (arr);
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
	_g_free0 (launcher_uri);
	_g_free0 (launched_uri);
	_g_object_unref0 (dai);
	_g_hash_table_unref0 (extra_params);
	_g_free0 (uri);
	_g_free0 (desktop_file);
	_g_variant_unref0 (dict);
	_g_variant_iter_free0 (uris);
	_g_variant_unref0 (desktop_variant);
}


static void desktop_launch_listener_real_stop (DataProvider* base) {
	DesktopLaunchListener * self;
	guint _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->launched_signal_id;
	if (_tmp0_ != ((guint) 0)) {
		GDBusConnection* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->bus;
		_tmp2_ = self->priv->launched_signal_id;
		g_dbus_connection_signal_unsubscribe (_tmp1_, _tmp2_);
		self->priv->launched_signal_id = (guint) 0;
	}
}


static const gchar* desktop_launch_listener_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


static void desktop_launch_listener_real_set_unique_id (DataProvider* base, const gchar* value) {
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_unique_id);
	self->priv->_unique_id = _tmp1_;
	g_object_notify ((GObject *) self, "unique-id");
}


static const gchar* desktop_launch_listener_real_get_name (DataProvider* base) {
	const gchar* result;
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void desktop_launch_listener_real_set_name (DataProvider* base, const gchar* value) {
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static const gchar* desktop_launch_listener_real_get_description (DataProvider* base) {
	const gchar* result;
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void desktop_launch_listener_real_set_description (DataProvider* base, const gchar* value) {
	DesktopLaunchListener* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static DataHub* desktop_launch_listener_real_get_datahub (DataProvider* base) {
	DataHub* result;
	DesktopLaunchListener* self;
	DataHub* _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}


static void desktop_launch_listener_real_set_datahub (DataProvider* base, DataHub* value) {
	DesktopLaunchListener* self;
	DataHub* _tmp0_;
	DataHub* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_datahub);
	self->priv->_datahub = _tmp1_;
	g_object_notify ((GObject *) self, "datahub");
}


static gboolean desktop_launch_listener_real_get_enabled (DataProvider* base) {
	gboolean result;
	DesktopLaunchListener* self;
	gboolean _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void desktop_launch_listener_real_set_enabled (DataProvider* base, gboolean value) {
	DesktopLaunchListener* self;
	gboolean _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = value;
	self->priv->_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "enabled");
}


static gboolean desktop_launch_listener_real_get_register (DataProvider* base) {
	gboolean result;
	DesktopLaunchListener* self;
	gboolean _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = self->priv->_register;
	result = _tmp0_;
	return result;
}


static void desktop_launch_listener_real_set_register (DataProvider* base, gboolean value) {
	DesktopLaunchListener* self;
	gboolean _tmp0_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = value;
	self->priv->_register = _tmp0_;
	g_object_notify ((GObject *) self, "register");
}


static GObject * desktop_launch_listener_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopLaunchListener * self;
	const gchar* _tmp4_ = NULL;
	const gchar* desktop_env;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (desktop_launch_listener_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_LAUNCH_LISTENER (obj);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->bus);
		self->priv->bus = _tmp1_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("desktop-launch-listener.vala:56: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp4_ = g_getenv ("XDG_CURRENT_DESKTOP");
	desktop_env = _tmp4_;
	_tmp5_ = desktop_env;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = desktop_env;
		g_desktop_app_info_set_desktop_env (_tmp6_);
		return obj;
	}
	return obj;
}


static void desktop_launch_listener_class_init (DesktopLaunchListenerClass * klass) {
	desktop_launch_listener_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopLaunchListenerPrivate));
	DATA_PROVIDER_CLASS (klass)->start = desktop_launch_listener_real_start;
	DATA_PROVIDER_CLASS (klass)->stop = desktop_launch_listener_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = desktop_launch_listener_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = desktop_launch_listener_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = desktop_launch_listener_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = desktop_launch_listener_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = desktop_launch_listener_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = desktop_launch_listener_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = desktop_launch_listener_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = desktop_launch_listener_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = desktop_launch_listener_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = desktop_launch_listener_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = desktop_launch_listener_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = desktop_launch_listener_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_desktop_launch_listener_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_desktop_launch_listener_set_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_launch_listener_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_launch_listener_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_UNIQUE_ID, g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_DATAHUB, g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_REGISTER, g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void desktop_launch_listener_instance_init (DesktopLaunchListener * self) {
	self->priv = DESKTOP_LAUNCH_LISTENER_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->launched_signal_id = (guint) 0;
}


static void desktop_launch_listener_finalize (GObject* obj) {
	DesktopLaunchListener * self;
	self = DESKTOP_LAUNCH_LISTENER (obj);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (desktop_launch_listener_parent_class)->finalize (obj);
}


GType desktop_launch_listener_get_type (void) {
	static volatile gsize desktop_launch_listener_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_launch_listener_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopLaunchListenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_launch_listener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopLaunchListener), 0, (GInstanceInitFunc) desktop_launch_listener_instance_init, NULL };
		GType desktop_launch_listener_type_id;
		desktop_launch_listener_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "DesktopLaunchListener", &g_define_type_info, 0);
		g_once_init_leave (&desktop_launch_listener_type_id__volatile, desktop_launch_listener_type_id);
	}
	return desktop_launch_listener_type_id__volatile;
}


static void _vala_desktop_launch_listener_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopLaunchListener * self;
	self = DESKTOP_LAUNCH_LISTENER (object);
	switch (property_id) {
		case DESKTOP_LAUNCH_LISTENER_UNIQUE_ID:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_NAME:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_DESCRIPTION:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_DATAHUB:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_ENABLED:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_REGISTER:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_desktop_launch_listener_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopLaunchListener * self;
	self = DESKTOP_LAUNCH_LISTENER (object);
	switch (property_id) {
		case DESKTOP_LAUNCH_LISTENER_UNIQUE_ID:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_NAME:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_DESCRIPTION:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_DATAHUB:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_ENABLED:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_REGISTER:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



