/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.Identity;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.UserException;
import Ice.Util;
import IceGrid.AMI_Admin_patchApplication;
import IceGrid.AMI_Admin_removeAdapter;
import IceGrid.AMI_Admin_removeObject;
import IceGrid.AMI_Admin_shutdownRegistry;
import IceGrid.AdapterDynamicInfo;
import IceGrid.AdapterInfo;
import IceGrid.AdminSessionPrx;
import IceGrid.ApplicationDescriptor;
import IceGrid.ApplicationInfo;
import IceGrid.ApplicationUpdateInfo;
import IceGrid.DeploymentException;
import IceGrid.FileIteratorPrx;
import IceGrid.FileIteratorPrxHelper;
import IceGrid.FileNotAvailableException;
import IceGrid.NodeDescriptor;
import IceGrid.NodeDynamicInfo;
import IceGrid.NodeUpdateDescriptor;
import IceGrid.ObjectExistsException;
import IceGrid.ObjectInfo;
import IceGrid.PropertySetDescriptor;
import IceGrid.RegistryInfo;
import IceGrid.RegistryNotExistException;
import IceGrid.RegistryUnreachableException;
import IceGrid.ReplicaGroupDescriptor;
import IceGrid.ServerDynamicInfo;
import IceGridGUI.Coordinator;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.ApplicationDetailsDialog;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ListArrayTreeNode;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.ObjectDialog;
import IceGridGUI.LiveDeployment.RegistryEditor;
import IceGridGUI.LiveDeployment.ShowLogDialog;
import IceGridGUI.LiveDeployment.Slave;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.TreeNodeBase;
import IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;

public class Root
extends ListArrayTreeNode {
    private final Coordinator _coordinator;
    private String _replicaName;
    private final List _nodes = new LinkedList();
    private final List _slaves = new LinkedList();
    private final Map _infoMap = new TreeMap();
    private SortedMap _adapters = new TreeMap();
    private SortedMap _objects = new TreeMap();
    private final JTree _tree;
    private final DefaultTreeModel _treeModel;
    private RegistryInfo _info;
    private String _label;
    private ObjectDialog _addObjectDialog;
    private ObjectDialog _showObjectDialog;
    final int _messageSizeMax;
    Map _showLogDialogMap = new HashMap();
    int _logMaxLines;
    int _logMaxSize;
    int _logInitialLines;
    int _logMaxReadSize;
    int _logPeriod;
    private ApplicationDetailsDialog _applicationDetailsDialog;
    private static RegistryEditor _editor;
    private static JPopupMenu _popup;
    private static DefaultTreeCellRenderer _cellRenderer;

    public Root(Coordinator coordinator) {
        super(null, "Root", 2);
        this._coordinator = coordinator;
        this._childrenArray[0] = this._slaves;
        this._childrenArray[1] = this._nodes;
        this._messageSizeMax = Util.getInstance(this._coordinator.getCommunicator()).messageSizeMax();
        this._tree = new JTree(this, true);
        this._treeModel = (DefaultTreeModel)this._tree.getModel();
        this._addObjectDialog = new ObjectDialog(this, false);
        this._showObjectDialog = new ObjectDialog(this, true);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) {
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (event.getPath().getLastPathComponent() == Root.this) {
                    throw new ExpandVetoException(event);
                }
            }
        });
        this.loadLogPrefs();
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[19];
        actions[18] = this._coordinator.connectedToMaster();
        actions[16] = true;
        actions[12] = true;
        actions[13] = true;
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRegistry() {
        final String prefix = "Shutting down registry '" + this._replicaName + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_shutdownRegistry cb = new AMI_Admin_shutdownRegistry(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to shutdown " + Root.this._replicaName, e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to shutdown " + Root.this._replicaName, e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().shutdownRegistry_async(cb, this._replicaName);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to shutdown " + this._replicaName, e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public ApplicationDescriptor getApplicationDescriptor(String name) {
        ApplicationInfo app = (ApplicationInfo)this._infoMap.get(name);
        if (app == null) {
            return null;
        }
        return app.descriptor;
    }

    public Object[] getApplicationNames() {
        return this._infoMap.keySet().toArray();
    }

    public Object[] getPatchableApplicationNames() {
        ArrayList result = new ArrayList();
        Iterator p = this._infoMap.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            ApplicationInfo app = (ApplicationInfo)entry.getValue();
            if (app.descriptor.distrib.icepatch.length() <= 0) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    public SortedMap getApplicationMap() {
        TreeMap r = new TreeMap();
        Iterator p = this._infoMap.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            ApplicationInfo app = (ApplicationInfo)entry.getValue();
            r.put(entry.getKey(), DateFormat.getDateTimeInstance().format(new Date(app.updateTime)));
        }
        return r;
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new RegistryEditor();
        }
        _editor.show(this);
        return _editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            ImageIcon icon = Utils.getIcon("/icons/16x16/registry.png");
            _cellRenderer.setOpenIcon(icon);
            _cellRenderer.setClosedIcon(icon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void applicationInit(String instanceName, String replicaName, List applications) {
        this.closeAllShowLogDialogs();
        this._replicaName = replicaName;
        this._label = instanceName + " (" + this._replicaName + ")";
        this._tree.setRootVisible(true);
        Iterator p = applications.iterator();
        while (p.hasNext()) {
            this.applicationAdded((ApplicationInfo)p.next());
        }
    }

    public void clear() {
        this._adapters.clear();
        this._objects.clear();
        this._replicaName = null;
        this._infoMap.clear();
        this._nodes.clear();
        this._slaves.clear();
        this._treeModel.nodeStructureChanged(this);
        this._tree.setRootVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patch(final String applicationName) {
        int shutdown = JOptionPane.showConfirmDialog(this._coordinator.getMainFrame(), "You are about to install or refresh your application distribution.\n Do you want shut down all servers affected by this update?", "Patch Confirmation", 1);
        if (shutdown == 2) {
            return;
        }
        final String prefix = "Patching application '" + applicationName + "'...";
        this._coordinator.getStatusBar().setText(prefix);
        AMI_Admin_patchApplication cb = new AMI_Admin_patchApplication(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to patch '" + applicationName + "'", e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to patch '" + applicationName + "'", e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().patchApplication_async(cb, applicationName, shutdown == 0);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to patch " + this._id, e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void showApplicationDetails(String appName) {
        ApplicationInfo app = (ApplicationInfo)this._infoMap.get(appName);
        if (app != null) {
            if (this._applicationDetailsDialog == null) {
                this._applicationDetailsDialog = new ApplicationDetailsDialog(this);
            }
            this._applicationDetailsDialog.showDialog(app);
        }
    }

    public void applicationAdded(ApplicationInfo info) {
        this._infoMap.put(info.descriptor.name, info);
        Iterator p = info.descriptor.nodes.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String nodeName = (String)entry.getKey();
            NodeDescriptor nodeDesc = (NodeDescriptor)entry.getValue();
            Node node = this.findNode(nodeName);
            if (node == null) {
                this.insertNode(new Node(this, info.descriptor, nodeName, nodeDesc));
                continue;
            }
            node.add(info.descriptor, nodeDesc);
        }
    }

    public void applicationRemoved(String name) {
        this._infoMap.remove(name);
        LinkedList<Node> toRemove = new LinkedList<Node>();
        int[] toRemoveIndices = new int[this._nodes.size()];
        int i = 0;
        for (int index = 0; index < this._nodes.size(); ++index) {
            Node node = (Node)this._nodes.get(index);
            if (!node.remove(name)) continue;
            toRemove.add(node);
            toRemoveIndices[i++] = this._slaves.size() + index;
        }
        this.removeNodes(this.resize(toRemoveIndices, toRemove.size()), toRemove);
    }

    public void applicationUpdated(ApplicationUpdateInfo update) {
        int i;
        ApplicationInfo app = (ApplicationInfo)this._infoMap.get(update.descriptor.name);
        app.updateTime = update.updateTime;
        app.updateUser = update.updateUser;
        app.revision = update.revision;
        ApplicationDescriptor appDesc = app.descriptor;
        if (update.descriptor.description != null) {
            appDesc.description = update.descriptor.description.value;
        }
        if (update.descriptor.distrib != null) {
            appDesc.distrib = update.descriptor.distrib.value;
        }
        appDesc.variables.keySet().removeAll(Arrays.asList(update.descriptor.removeVariables));
        appDesc.variables.putAll(update.descriptor.variables);
        boolean variablesChanged = update.descriptor.removeVariables.length > 0 || !update.descriptor.variables.isEmpty();
        appDesc.propertySets.keySet().removeAll(Arrays.asList(update.descriptor.removePropertySets));
        appDesc.propertySets.putAll(update.descriptor.propertySets);
        block0: for (i = 0; i < update.descriptor.removeReplicaGroups.length; ++i) {
            for (int j = 0; j < appDesc.replicaGroups.size(); ++j) {
                ReplicaGroupDescriptor rgd = (ReplicaGroupDescriptor)appDesc.replicaGroups.get(j);
                if (!rgd.id.equals(update.descriptor.removeReplicaGroups[i])) continue;
                appDesc.replicaGroups.remove(j);
                continue block0;
            }
        }
        for (i = 0; i < update.descriptor.replicaGroups.size(); ++i) {
            ReplicaGroupDescriptor newRgd = (ReplicaGroupDescriptor)update.descriptor.replicaGroups.get(i);
            boolean replaced = false;
            for (int j = 0; j < appDesc.replicaGroups.size() && !replaced; ++j) {
                ReplicaGroupDescriptor oldRgd = (ReplicaGroupDescriptor)appDesc.replicaGroups.get(j);
                if (!newRgd.id.equals(oldRgd.id)) continue;
                appDesc.replicaGroups.set(j, newRgd);
                replaced = true;
            }
            if (replaced) continue;
            appDesc.replicaGroups.add(newRgd);
        }
        appDesc.serviceTemplates.keySet().removeAll(Arrays.asList(update.descriptor.removeServiceTemplates));
        appDesc.serviceTemplates.putAll(update.descriptor.serviceTemplates);
        appDesc.serverTemplates.keySet().removeAll(Arrays.asList(update.descriptor.removeServerTemplates));
        appDesc.serverTemplates.putAll(update.descriptor.serverTemplates);
        appDesc.nodes.keySet().removeAll(Arrays.asList(update.descriptor.removeNodes));
        for (i = 0; i < update.descriptor.removeNodes.length; ++i) {
            Node node = this.findNode(update.descriptor.removeNodes[i]);
            if (!node.remove(update.descriptor.name)) continue;
            int index = this.getIndex(node);
            this._nodes.remove(node);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
        }
        Iterator p = update.descriptor.nodes.iterator();
        HashSet<Node> freshNodes = new HashSet<Node>();
        while (p.hasNext()) {
            NodeUpdateDescriptor nodeUpdateDesc = (NodeUpdateDescriptor)p.next();
            String nodeName = nodeUpdateDesc.name;
            Node node = this.findNode(nodeName);
            if (node == null) {
                node = new Node(this, appDesc, nodeUpdateDesc);
                this.insertNode(node);
            } else {
                node.update(appDesc, nodeUpdateDesc, variablesChanged, update.descriptor.serviceTemplates.keySet(), update.descriptor.serverTemplates.keySet());
            }
            freshNodes.add(node);
        }
        if (variablesChanged || !update.descriptor.serviceTemplates.isEmpty() || !update.descriptor.serverTemplates.isEmpty()) {
            p = this._nodes.iterator();
            while (p.hasNext()) {
                Node node = (Node)p.next();
                if (freshNodes.contains(node)) continue;
                node.update(appDesc, null, variablesChanged, update.descriptor.serviceTemplates.keySet(), update.descriptor.serverTemplates.keySet());
            }
        }
    }

    public void adapterInit(AdapterInfo[] adapters) {
        for (int i = 0; i < adapters.length; ++i) {
            this._adapters.put(adapters[i].id, adapters[i]);
        }
    }

    public void adapterAdded(AdapterInfo info) {
        this._adapters.put(info.id, info);
    }

    public void adapterUpdated(AdapterInfo info) {
        this._adapters.put(info.id, info);
    }

    public void adapterRemoved(String id) {
        this._adapters.remove(id);
    }

    public void objectInit(ObjectInfo[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            this._objects.put(Util.identityToString(objects[i].proxy.ice_getIdentity()), objects[i]);
        }
    }

    public void objectAdded(ObjectInfo info) {
        this._objects.put(Util.identityToString(info.proxy.ice_getIdentity()), info);
    }

    public void objectUpdated(ObjectInfo info) {
        this._objects.put(Util.identityToString(info.proxy.ice_getIdentity()), info);
    }

    public void objectRemoved(Identity id) {
        this._objects.remove(Util.identityToString(id));
    }

    public void registryUp(RegistryInfo info) {
        if (info.name.equals(this._replicaName)) {
            this._info = info;
        } else {
            String otherName;
            int i;
            Slave newSlave = new Slave(this, info, this._replicaName);
            for (i = 0; i < this._slaves.size() && info.name.compareTo(otherName = this._slaves.get(i).toString()) >= 0; ++i) {
            }
            this._slaves.add(i, newSlave);
            this._treeModel.nodesWereInserted(this, new int[]{i});
        }
    }

    public void registryDown(String name) {
        TreeNodeBase registry = this.find(name, this._slaves);
        if (registry != null) {
            int index = this.getIndex(registry);
            this._slaves.remove(registry);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{registry});
        }
    }

    public void nodeUp(NodeDynamicInfo updatedInfo) {
        Node node = this.findNode(updatedInfo.info.name);
        if (node != null) {
            node.up(updatedInfo, true);
        } else {
            this.insertNode(new Node(this, updatedInfo));
        }
    }

    public void nodeDown(String nodeName) {
        Node node = this.findNode(nodeName);
        if (node != null && node.down()) {
            int index = this.getIndex(node);
            this._nodes.remove(node);
            this._treeModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
        }
    }

    public void updateServer(String nodeName, ServerDynamicInfo updatedInfo) {
        Node node = this.findNode(nodeName);
        if (node != null) {
            node.updateServer(updatedInfo);
        }
    }

    public void updateAdapter(String nodeName, AdapterDynamicInfo updatedInfo) {
        Node node = this.findNode(nodeName);
        if (node != null) {
            node.updateAdapter(updatedInfo);
        }
    }

    public JPopupMenu getPopupMenu() {
        LiveActions la = this._coordinator.getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(18));
            _popup.addSeparator();
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.addSeparator();
            _popup.add(la.get(16));
        }
        la.setTarget(this);
        return _popup;
    }

    public void setSelectedNode(TreeNode node) {
        this._tree.setSelectionPath(node.getPath());
    }

    public JTree getTree() {
        return this._tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this._treeModel;
    }

    public Coordinator getCoordinator() {
        return this._coordinator;
    }

    public String toString() {
        return this._label;
    }

    public boolean hasNode(TreeNode node) {
        while (node != this) {
            TreeNode parent = (TreeNode)node.getParent();
            if (parent.getIndex(node) == -1) {
                return false;
            }
            node = parent;
        }
        return true;
    }

    public void addObject() {
        this._addObjectDialog.showDialog();
    }

    public void showObject(String proxy, String type) {
        this._showObjectDialog.showDialog(proxy, type);
    }

    Root getRoot() {
        return this;
    }

    SortedMap getObjects() {
        return this._objects;
    }

    SortedMap getAdapters() {
        return this._adapters;
    }

    RegistryInfo getRegistryInfo() {
        return this._info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addObject(String strProxy, String type) {
        ObjectPrx proxy = null;
        try {
            proxy = this._coordinator.getCommunicator().stringToProxy(strProxy);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "Cannot parse proxy '" + strProxy + "'", "addObject failed", 0);
            return false;
        }
        if (proxy == null) {
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "You must provide a non-null proxy", "addObject failed", 0);
            return false;
        }
        String strIdentity = Util.identityToString(proxy.ice_getIdentity());
        String prefix = "Adding well-known object '" + strIdentity + "'...";
        try {
            this._coordinator.getStatusBar().setText(prefix);
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (type == null) {
                this._coordinator.getAdmin().addObject(proxy);
            } else {
                this._coordinator.getAdmin().addObjectWithType(proxy, type);
            }
        }
        catch (ObjectExistsException e) {
            this._coordinator.getStatusBar().setText(prefix + "failed.");
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "An object with this identity is already registered as a well-known object", "addObject failed", 0);
            boolean bl = false;
            return bl;
        }
        catch (DeploymentException e) {
            this._coordinator.getStatusBar().setText(prefix + "failed.");
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), "Deployment exception: " + e.reason, "addObject failed", 0);
            boolean bl = false;
            return bl;
        }
        catch (LocalException e) {
            this._coordinator.getStatusBar().setText(prefix + "failed.");
            JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), e.toString(), "addObject failed", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
        this._coordinator.getStatusBar().setText(prefix + "done.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObject(String strProxy) {
        ObjectPrx proxy = this._coordinator.getCommunicator().stringToProxy(strProxy);
        Identity identity = proxy.ice_getIdentity();
        final String strIdentity = Util.identityToString(identity);
        final String prefix = "Removing well-known object '" + strIdentity + "'...";
        this._coordinator.getStatusBar().setText(prefix);
        AMI_Admin_removeObject cb = new AMI_Admin_removeObject(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to remove object '" + strIdentity + "'", e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to remove object '" + strIdentity + "'", e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().removeObject_async(cb, identity);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to remove object '" + strIdentity + "'", e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAdapter(final String adapterId) {
        final String prefix = "Removing adapter '" + adapterId + "'...";
        this._coordinator.getStatusBar().setText(prefix);
        AMI_Admin_removeAdapter cb = new AMI_Admin_removeAdapter(){

            public void ice_response() {
                Root.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Root.this.amiFailure(prefix, "Failed to remove adapter '" + adapterId + "'", e);
            }

            public void ice_exception(LocalException e) {
                Root.this.amiFailure(prefix, "Failed to remove adapter '" + adapterId + "'", e.toString());
            }
        };
        try {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this._coordinator.getAdmin().removeAdapter_async(cb, adapterId);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to remove adapter '" + adapterId + "'", e.toString());
        }
        finally {
            this._coordinator.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogDialog(new ShowLogDialog.FileIteratorFactory(){

            public FileIteratorPrx open(int count) throws FileNotAvailableException, RegistryNotExistException, RegistryUnreachableException {
                AdminSessionPrx session = Root.this._coordinator.getSession();
                FileIteratorPrx result = stdout ? session.openRegistryStdOut(Root.this._replicaName, count) : session.openRegistryStdErr(Root.this._replicaName, count);
                if (Root.this._coordinator.getCommunicator().getDefaultRouter() == null) {
                    result = FileIteratorPrxHelper.uncheckedCast(result.ice_endpoints(session.ice_getEndpoints()));
                }
                return result;
            }

            public String getTitle() {
                return "Registry " + Root.this._label + " " + (stdout ? "stdout" : "stderr");
            }

            public String getDefaultFilename() {
                return Root.this._replicaName + (stdout ? ".out" : ".err");
            }
        });
    }

    PropertySetDescriptor findNamedPropertySet(String name, String applicationName) {
        ApplicationInfo app = (ApplicationInfo)this._infoMap.get(applicationName);
        return (PropertySetDescriptor)app.descriptor.propertySets.get(name);
    }

    void openShowLogDialog(ShowLogDialog.FileIteratorFactory factory) {
        ShowLogDialog d = (ShowLogDialog)this._showLogDialogMap.get(factory.getTitle());
        if (d == null) {
            d = new ShowLogDialog(this, factory, this._logMaxLines, this._logMaxSize, this._logInitialLines, this._logMaxReadSize, this._logPeriod);
            this._showLogDialogMap.put(factory.getTitle(), d);
        } else {
            d.toFront();
        }
    }

    void removeShowLogDialog(String title) {
        this._showLogDialogMap.remove(title);
    }

    public void closeAllShowLogDialogs() {
        Iterator p = this._showLogDialogMap.values().iterator();
        while (p.hasNext()) {
            ShowLogDialog d = (ShowLogDialog)p.next();
            d.close(false);
        }
        this._showLogDialogMap.clear();
    }

    public int getMessageSizeMax() {
        return this._messageSizeMax;
    }

    public void setLogPrefs(int maxLines, int maxSize, int initialLines, int maxReadSize, int period) {
        this._logMaxLines = maxLines;
        this._logMaxSize = maxSize;
        this._logInitialLines = initialLines;
        this._logMaxReadSize = maxReadSize;
        this._logPeriod = period;
        this.storeLogPrefs();
    }

    private void loadLogPrefs() {
        Preferences logPrefs = this._coordinator.getPrefs().node("Log");
        this._logMaxLines = logPrefs.getInt("maxLines", 500);
        this._logMaxSize = logPrefs.getInt("maxSize", 20000);
        this._logInitialLines = logPrefs.getInt("initialLines", 10);
        this._logMaxReadSize = logPrefs.getInt("maxReadSize", 10000);
        this._logPeriod = logPrefs.getInt("period", 300);
        if (this._logMaxReadSize + 512 > this._messageSizeMax) {
            this._logMaxReadSize = this._messageSizeMax - 512;
        }
    }

    private void storeLogPrefs() {
        Preferences logPrefs = this._coordinator.getPrefs().node("Log");
        logPrefs.putInt("maxLines", this._logMaxLines);
        logPrefs.putInt("maxSize", this._logMaxSize);
        logPrefs.putInt("initialLines", this._logInitialLines);
        logPrefs.putInt("maxReadSize", this._logMaxReadSize);
        logPrefs.putInt("period", this._logPeriod);
    }

    private Node findNode(String nodeName) {
        return (Node)this.find(nodeName, this._nodes);
    }

    private void insertNode(Node node) {
        String otherNodeName;
        int i;
        String nodeName = node.toString();
        for (i = 0; i < this._nodes.size() && nodeName.compareTo(otherNodeName = this._nodes.get(i).toString()) >= 0; ++i) {
        }
        this._nodes.add(i, node);
        this._treeModel.nodesWereInserted(this, new int[]{this._slaves.size() + i});
    }

    private void removeNodes(int[] toRemoveIndices, List toRemove) {
        if (toRemove.size() > 0) {
            this._nodes.removeAll(toRemove);
            this._treeModel.nodesWereRemoved(this, toRemoveIndices, toRemove.toArray());
        }
    }
}

