/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.StringHolder;
import IceGrid.PropertyDescriptor;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;

public class Utils {
    public static ImageIcon getIcon(String path) {
        URL imgURL = Utils.class.getResource(path);
        if (imgURL == null) {
            System.err.println("Could not find icon " + path);
            return null;
        }
        return new ImageIcon(imgURL);
    }

    public static String stringify(Collection col, Stringifier stringifier, String separator, StringHolder toolTipHolder) {
        String result = "";
        if (toolTipHolder != null) {
            toolTipHolder.value = null;
        }
        Iterator p = col.iterator();
        boolean firstElement = true;
        while (p.hasNext()) {
            String elt = stringifier.toString(p.next());
            if (elt == null) continue;
            if (firstElement) {
                firstElement = false;
                if (toolTipHolder != null) {
                    toolTipHolder.value = "<html>";
                }
            } else {
                result = result + separator;
                if (toolTipHolder != null) {
                    toolTipHolder.value = toolTipHolder.value + "<br>";
                }
            }
            result = elt.length() == 0 ? result + "\"\"" : (elt.matches("\\S*") ? result + elt : result + '\"' + elt + '\"');
            if (toolTipHolder == null) continue;
            toolTipHolder.value = toolTipHolder.value + elt;
        }
        if (toolTipHolder != null && toolTipHolder.value != null) {
            toolTipHolder.value = toolTipHolder.value + "</html>";
        }
        return result;
    }

    public static String substitute(String input, Resolver resolver) {
        if (resolver != null) {
            return resolver.substitute(input);
        }
        return input;
    }

    public static SortedMap propertySetsToMap(List propertySets, Resolver resolver) {
        TreeMap toMap = new TreeMap();
        Iterator p = propertySets.iterator();
        while (p.hasNext()) {
            ExpandedPropertySet propertySet = (ExpandedPropertySet)p.next();
            Utils.addSet(propertySet, resolver, toMap);
        }
        return toMap;
    }

    private static void addSet(ExpandedPropertySet set, Resolver resolver, SortedMap toMap) {
        for (int i = 0; i < set.references.length; ++i) {
            Utils.addSet(set.references[i], resolver, toMap);
        }
        Iterator p = set.properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            String name = pd.name;
            String val = pd.value;
            name = Utils.substitute(pd.name, resolver);
            val = Utils.substitute(pd.value, resolver);
            toMap.put(name, val);
        }
    }

    public static class ExpandedPropertySet {
        public ExpandedPropertySet[] references;
        public List properties;
    }

    public static class Resolver {
        private Map[] _variables;
        private Map _parameters;
        private Map _predefinedVariables;
        private Resolver _subResolver;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Resolver(Map variables) {
            this(new Map[]{variables});
        }

        public Resolver(Map[] variables) {
            this._variables = variables;
            this._predefinedVariables = new HashMap();
            this._parameters = null;
            this._subResolver = this;
        }

        public Resolver(Resolver parent, Map parameters, Map defaults) {
            this._variables = parent._variables;
            this.reset(parent, parameters, defaults);
        }

        public Resolver(Resolver parent) {
            this._variables = parent._variables;
            this._predefinedVariables = new HashMap(parent._predefinedVariables);
            this._parameters = parent._parameters;
            this._subResolver = this._parameters == null ? this : new Resolver(this._variables, this._predefinedVariables);
        }

        private Resolver(Map[] variables, Map predefinedVariables) {
            this._variables = variables;
            this._predefinedVariables = this._predefinedVariables;
            this._parameters = null;
            this._subResolver = this;
        }

        public String find(String name) {
            Object obj;
            if (this._parameters != null && (obj = this._parameters.get(name)) != null) {
                return (String)obj;
            }
            obj = this._predefinedVariables.get(name);
            if (obj != null) {
                return (String)obj;
            }
            for (int i = 0; i < this._variables.length; ++i) {
                obj = this._variables[i].get(name);
                if (obj == null) continue;
                return this._subResolver.substitute((String)obj);
            }
            return null;
        }

        public boolean put(String name, String value) {
            String oldVal = (String)this._predefinedVariables.get(name);
            if (oldVal == null || !oldVal.equals(value)) {
                this._predefinedVariables.put(name, value);
                return true;
            }
            return false;
        }

        public void reset(Resolver parent, Map parameters, Map defaults) {
            if (!$assertionsDisabled && this._variables != parent._variables) {
                throw new AssertionError();
            }
            this._predefinedVariables = new HashMap(parent._predefinedVariables);
            this._parameters = parent.substituteParameterValues(parameters, defaults);
            this._subResolver = new Resolver(this._variables, this._predefinedVariables);
        }

        public void reset(Resolver parent) {
            if (!$assertionsDisabled && this._variables != parent._variables) {
                throw new AssertionError();
            }
            this._predefinedVariables = new HashMap(parent._predefinedVariables);
            if (!$assertionsDisabled && this._parameters != parent._parameters) {
                throw new AssertionError();
            }
            this._subResolver = this._parameters == null ? this : new Resolver(this._variables, this._predefinedVariables);
        }

        public String substitute(String input) {
            if (input == null) {
                return input;
            }
            int beg = 0;
            int end = 0;
            while ((beg = input.indexOf("${", beg)) != -1) {
                if (beg > 0 && input.charAt(beg - 1) == '$') {
                    int escape;
                    for (escape = beg - 1; escape > 0 && input.charAt(escape - 1) == '$'; --escape) {
                    }
                    input = input.substring(0, escape) + input.substring(beg - (beg - escape) / 2);
                    if ((beg - escape) % 2 != 0) {
                        ++beg;
                        continue;
                    }
                    beg -= (beg - escape) / 2;
                }
                if ((end = input.indexOf(125, beg)) == -1) {
                    return input;
                }
                String name = input.substring(beg + 2, end);
                String val = this.find(name);
                if (val != null) {
                    input = input.substring(0, beg) + val + input.substring(end + 1);
                    beg += val.length();
                    continue;
                }
                ++beg;
            }
            return input;
        }

        public Map substituteParameterValues(Map input, Map defaults) {
            Map.Entry entry;
            HashMap result = new HashMap();
            Iterator p = input.entrySet().iterator();
            while (p.hasNext()) {
                entry = p.next();
                result.put(entry.getKey(), this.substitute((String)entry.getValue()));
            }
            p = defaults.entrySet().iterator();
            while (p.hasNext()) {
                entry = p.next();
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), this.substitute((String)entry.getValue()));
            }
            return result;
        }

        static {
            $assertionsDisabled = !(class$IceGridGUI$Utils == null ? (class$IceGridGUI$Utils = Utils.class$("IceGridGUI.Utils")) : class$IceGridGUI$Utils).desiredAssertionStatus();
        }
    }

    public static interface Stringifier {
        public String toString(Object var1);
    }
}

