# testDeclaration.py
# This test case generates a complete declaration and ensures its storage in the system is good (in particular, order is respected !)
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

# Permissions / security
from AccessControl.Permissions import access_contents_information, view, add_documents_images_and_files, change_images_and_files, view_management_screens
from AccessControl import Unauthorized

_standard_permissions = ZopeTestCase._standard_permissions
_access_permissions   = [view_management_screens,]                      # Access attachment attributes (this is a silly permissions, for test purposes only)
_edit_permissions     = [change_images_and_files,]                      # Edit attachment attributes (silly permission as well)
_all_permissions      = _standard_permissions+_access_permissions


# Install our products
ZopeTestCase.installProduct('ZAttachmentAttribute')
ZopeTestCase.installProduct('ZAAPlugins')

from global_symbols import *

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAAPlugins.PDF import PDFAttachment
from Products.ZAAPlugins.MSWord import MSWordAttachment



class TestPlugins(ZopeTestCase.ZopeTestCase):


    def test_01_MSWord(self,):
        """ Upload and index an MSWord document."""
        att = ZAttachmentAttribute.ZAttachmentAttribute()
        (attachment_class, class_globals) = ZAttachmentRegistry.AttachmentRegistry.getAttachmentClass("application/msword")
        f = open("test.doc", "r")
        att.uploadAttachment(attachment_class, class_globals, "application/msword", f)
        self.failUnless("exemple" not in att.listIndexableValues(), "File is not indexed properly !")

    def test_02_Text(self,):
        """ Upload and index an text-only file."""
        att = ZAttachmentAttribute.ZAttachmentAttribute()
        (attachment_class, class_globals) = ZAttachmentRegistry.AttachmentRegistry.getAttachmentClass("text/plain")
        f = open("test.txt", "r")
        att.uploadAttachment(attachment_class, class_globals, "text/plain", f)
        self.failUnless("exemple" not in att.listIndexableValues(), "File is not indexed properly !")



if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
else:
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(TestPlugins))
        return suite
