;;;
;;; $Id: tl-list.el,v 6.3 1995/09/12 22:20:10 morioka Exp $
;;;


;;; @ list
;;;

(defun last (list)
  "Returns the last element in the list <LIST>.
[tl-list; mol's Common Lisp emulating function]"
  (nthcdr (- (length list) 1) list)
  )

(defun butlast (x &optional n)
  "Returns a copy of LIST with the last N elements removed.
[tl-list; imported from cl.el]"
  (if (and n (<= n 0)) x
    (nbutlast (copy-sequence x) n)))

(defun nbutlast (x &optional n)
  "Modifies LIST to remove the last N elements.
[tl-list; imported from cl.el]"
  (let ((m (length x)))
    (or n (setq n 1))
    (and (< n m)
	 (progn
	   (if (> n 0) (setcdr (nthcdr (- (1- m) n) x) nil))
	   x))))


(defun nth-prev (n ls)
  "Return elements of LS until N - 1 th. [tl-list]"
  (butlast ls (- (length ls) n))
  )

(defun except-nth (n ls)
  "Return elements of LS except N th. [tl-list]"
  (append (nth-prev n ls) (nthcdr (+ 1 n) ls))
  )

(defun last-element (ls)
  "Return last element. [tl-list]"
  (car (last ls))
  )

(defun cons-element (elt ls)
  "Append ELT to first of LS if ELT is not nil. [tl-list]"
  (if elt
      (cons elt ls)
    ls))

(defun append-element (ls elt)
  "Append ELT to last of LS if ELT is not nil. [tl-list]"
  (if elt
      (append ls (list elt))
    ls))


;;; @ permutation and combination
;;;

(defun every-combination (prev &rest rest)
  "Every arguments are OR list,
and return list of all possible sequence. [tl-list]"
  (if (null prev)
      (setq prev '(nil))
    )
  (cond ((null rest)
	 (mapcar 'list prev)
	 )
	(t (let (dest
		 (pr prev)
		 (rest-mixed (apply 'every-combination rest))
		 )
	     (while pr
	       (let ((rr rest-mixed))
		 (while rr
		   (setq dest (cons (cons (car pr)(car rr)) dest))
		   (setq rr (cdr rr))
		   ))
	       (setq pr (cdr pr))
	       )
	     (reverse dest)
	     ))
	))

(defun permute (&rest ls)
  "Return permutation of arguments as list. [tl-list]"
  (let ((len (length ls)))
    (if (<= len 1)
	(list ls)
      (let (prev
	    (rest ls)
	    c dest ret)
	(while rest
	  (setq c (car rest))
	  (setq rest (cdr rest))
	  (setq dest
		(append dest
			(mapcar (function
				 (lambda (s)
				   (cons c s)
				   ))
				(apply (function permute)
				       (append prev rest))
				)))
	  (setq prev (append prev (list c)))
	  )
	dest)
      )))


;;; @ index
;;;

(defun index (start end &optional inc)
  "Return list of numbers from START to END.
Element of the list increases by INC (default value is 1).
\[tl-list; ELIS compatible function]"
  (if (null inc)
      (setq inc 1)
    )
  (let ((pred
	 (if (>= inc 0)
	     (function <=)
	   (function >=)
	   ))
	(i start) dest)
    (while (funcall pred i end)
      (setq dest (cons i dest))
      (setq i (+ i inc))
      )
    (reverse dest)
    ))


;;; @ set
;;;

(defun subsetp (set1 set2)
  (catch 'tag
    (let (obj)
      (while set1
	(setq obj (car set1))
	(if (not (member obj set2))
	    (throw 'tag nil)
	  )
	(setq set1 (cdr set1))
	)
      t)))

(defun map-union (func ls)
  "Apply FUNC to each element of LS.
And return union of each result returned by FUNC. [tl-list]"
  (let ((r ls) ret rc dest)
    (while r
      (setq ret (funcall func (car r)))
      (while ret
	(setq rc (car ret))
	(if (not (member rc dest))
	    (setq dest (cons rc dest))
	  )
	(setq ret (cdr ret))
	)
      (setq r (cdr r))
      )
    (reverse dest)
    ))


;;; @ alist
;;;

(defun put-alist (item value alist)
  "If there is a pair whose car is <ITEM>, replace its cdr by <VALUE>.
If there is not such pair, create new pair (<ITEM> . <VALUE>) and
return new alist whose car is the new pair and cdr is <ALIST>.
\[tl-list; mol's ELIS emulating function]"
  (if (assoc item alist)
      (progn
	(rplacd (assoc item alist) value)
	alist)
    (cons (cons item value) alist)
    ))

(defun del-alist (item alist)
  "If there is a pair whose key is <ITEM>, delete it from <ALIST>.
\[tl-list; mol's ELIS emulating function]"
  (if (equal item (car (car alist)))
      (cdr alist)
    (let ((pr alist)
	  (r (cdr alist))
	  )
      (catch 'tag
	(while (not (null r))
	  (if (equal item (car (car r)))
	      (progn
		(rplacd pr (cdr r))
		(throw 'tag alist)))
	  (setq pr r)
	  (setq r (cdr r))
	  )
	alist))))

(defun assoc-value (item alist)
  "Return value of <ITEM> from <ALIST>. [tl-list]"
  (cdr (assoc item alist))
  )

(defun set-alist (sym item value)
  "Modify a alist indicated by a symbol SYM
into a slot value whose key is ITEM is VALUE. [tl-list]"
  (if (not (boundp sym))
      (set sym nil)
    )
  (set sym (put-alist item value (eval sym)))
  )

(defun modify-alist (modifier default)
  "Modify alist DEFAULT into alist MODIFIER. [tl-list]"
  (mapcar (function
	   (lambda (as)
	     (setq default (put-alist (car as)(cdr as) default))
	     ))
	  modifier)
  default)

(defun set-modified-alist (sym modifier)
  "Modify a value of a symbol SYM into alist MODIFIER.
The symbol SYM should be alist. If it is not bound,
its value regard as nil. [tl-list]"
  (if (not (boundp sym))
      (set sym nil)
    )
  (set sym (modify-alist modifier (eval sym)))
  )


;;; @ end
;;;

(provide 'tl-list)

(require 'tl-seq)
(require 'tl-atype)
