/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFrdI1 (AFILE *AFp, float Fbuff[], int Nreq)

Purpose:
  Read 8-bit integer data from an audio file (return float values)

Description:
  This routine reads a specified number of 8-bit integer samples from an audio
  file.  The data in the file is converted to float format on output.

Parameters:
  <-  int AFrdI1
      Number of data values transferred from the file.  On reaching the end of
      the file, this value may be less than Nreq.
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenRead
  <-  float Fbuff[]
      Array of floats to receive the samples
   -> int Nreq
      Number of samples requested.  Nreq may be zero.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.8 $  $Date: 1997/10/15 13:42:13 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFrdI1.c 1.8 1997/10/15 libtsp-v3r0 $";

#include <libtsp/AFdataio.h>
#include <libtsp/Xstdio.h>
#include <libtsp/AFpar.h>
#include <libtsp/UTtypes.h>

#define LW		FDL_INT8
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

#define FREAD(buf,size,nv,fp)	(int) fread ((char *) buf, (size_t) size, \
					     (size_t) nv, fp)


int
AFrdI1 (AFp, Fbuff, Nreq)

     AFILE *AFp;
     float Fbuff[];
     int Nreq;

{
  int is, N, i, Nr, Iv;
  uint1_t Buf[NBBUF/LW];

  for (is = 0; is < Nreq; ) {

    /* Read data from the audio file */
    N = MINV (NBBUF / LW, Nreq - is);
    Nr = FREAD (Buf, LW, N, AFp->fp);

    /* Convert to float */
    for (i = 0; i < Nr; ++i) {
      Iv = Buf[i];
      if (Iv >= 128)
	Iv -= 256;	/* No "signed" 1 byte int in non-ANSI C */
      Fbuff[is] = AFp->ScaleF * Iv;
      ++is;
    }

    if (Nr < N)
      break;
  }

  return is;
}
