/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *UTgetUser (void)

Purpose:
  Get the user name

Description:
  This routine returns the user name.  The user name is determined by using
  the user id to find the name in the password database with this uid.  For
  systems that do not support the password database, the user name is taken
  from the environment variables USER, LOGNAME or USERNAME.

Parameters:
  <-  char UTgetUser[]
      Pointer to a character string containing the user name.  This string is
      null terminated.  This is a pointer to an internal static storage area;
      each call to this routine overlays this storage.

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.8 $  $Date: 1998/04/07 20:10:32 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTgetUser.c 1.8 1998/04/07 libtsp-v3r0 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/sysOS.h>	/* OS defines */
#include <libtsp/UTmsg.h>

#ifdef unix
#  include <unistd.h>		/* getuid definitions */
#  include <pwd.h>		/* password entry definitions */
#else
#  include <stdlib.h>		/* getenv */
#endif

#define NELEM(array)	((sizeof array) / (sizeof array[0]))

/* The user name is at most 8 characters long on many Unix systems */
#define MAXLEN	16


char *
UTgetUser ()

{
  static char User[MAXLEN+1];

#ifdef unix
  struct passwd *pwd;

/*
   Find the password entry associated with the uid.  Using environment
   variables such as USER does not work consistently since not all shells set
   these environment variables for the user.
*/
  User[0] = '\0';
  pwd = getpwuid (getuid ());
  if (pwd != NULL)
    STcopyMax (pwd->pw_name, User, MAXLEN);
  else
    UTwarn ("UTgetUser - %s", UTM_NoUser);

#else
  char * p;
  int i;
  static const char *UserEnv[] = { "USER", "LOGNAME", "USERNAME" };
#define NENV	NELEM(UserEnv)

  User[0] = '\0';
  for (i = 0; i < NENV; ++i) {
    p = getenv (UserEnv[i]);
    if (p != NULL) {
      STcopyMax (p, User, MAXLEN);
      break;
    }
  }

#endif

  return User;
}
