/*
 *   datamove.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*    This module contains the definitions used by datamove.c for DMA setup.*/


#ifndef __DATAMOVE_H_
#define __DATAMOVE_H_

/******************************************************************************/
/*  PC2GPC offsets from CNTLBLK*/
/******************************************************************************/
#define PFTCNT    0x0
#define PFTPTR    0x2
#define NPFTCNT   0x4
#define NPFTPTR   0x6
#define MOVECTL   0x8
#define MAXDMAR   0x0A
#define MAXWINQ   0x0C
#define MOVESTAT  0x0E
#define PFTTOTAL  0x10
#define SHADPTR   0x14
#define SHADCNT   0x18
#define PRIVPTR   0x1a
#define PRIVCNT   0x1e
#define PCERRFLG  0x20
#define PTRPUTD   0x22
#define GPCSEG    0x24

enum NadType { NAD_PLAY_DM, NAD_RECORD_DM };

enum NadMessage { NAD_GET_VERSION, NAD_LOADED, NAD_UNLOADING };

#define MAXPFTENTRIES   17

typedef struct Cntlblk
{
   WORD         pftcnt;
   WORD         pftptr;
   WORD         npftcnt;
   WORD         npftptr;
   WORD         movectl;
   WORD         maxdmar;
   WORD         maxwinq;
   WORD         movestat;
   DWORD        pfttotal;
   WORD         shadptr;
   WORD         shadcnt;
   DWORD        privptr;
   WORD         privcnt;
   WORD         pcerrflg;
   WORD         ptrpputd;
   WORD         gpcseg;
} Cntlblk_t;

typedef struct Datamover
{
   DWORD        size;           /* size of this structure*/
   DWORD        ipcHandle;      /* IPC handle owned by this task*/
   DWORD        dspaddrCNTLBLK; /* address in DSTORE of CNTLBLK label*/
   DWORD        pftEntries;     /* max # of entries in the allocated tables*/
   DWORD        pftEntriesUsed; /* # of entries filled in the allocated tables*/
   DWORD        dspaddrPFTTABLE1;  /* address in DSTORE of a table*/
   DWORD        dspaddrPFTTABLE2;  /* address in DSTORE of a table*/
} Datamover_t;

typedef struct NadStream
{
   DWORD        size;           /* size of this structure*/
   DWORD        type;           /* the type of this structure*/
} NadStream_t;

typedef struct NadDatamoverStream
{
   NadStream_t nadStream;
   Datamover_t Datamover;
} NadDatamoverStream_t;

typedef struct pftEntry
{
   DWORD        address;
   WORD         size;
} pftEntry_t;

typedef struct pftptrr
{
   WORD        pftcnt;
   WORD        pftptr;
} pftptr_t;

#endif /* __DATAMOVE_H_ */

