type tat =
  { mutable dtransitions : transition array;
    dterminal : bool }
and transition =
  | Vers of tat
  | Rejet;;

exception chec;;

let reconnat automate chane =
  let tat_courant = ref automate in 
  try
    for i = 0 to String.length chane - 1 do
    match !tat_courant.dtransitions.(int_of_char chane.[i]) with
    | Rejet  -> raise chec
    | Vers e -> tat_courant := e
    done;
    !tat_courant.dterminal
  with chec -> false;;

open Auto;;

type ensemble_d'tats =
  { contenu  : Ensent.t;
    lments : Auto.tat list };;

let vide = { contenu = Ensent.vide; lments = [] };;

let est_vide ens =
  match ens.lments with [] -> true | _ -> false;;

let appartient tat ens =
  Ensent.appartient tat.numro ens.contenu;;

let ajoute tat ens =
  { contenu  = Ensent.ajoute tat.numro ens.contenu;
    lments = tat :: ens.lments };;

let rec ajoute_fermeture tat ferm =
  if appartient tat ferm then ferm else
    List.fold_right ajoute_fermeture
      tat.epsilon_transitions (ajoute tat ferm);;

let fermeture tat = ajoute_fermeture tat vide;;

let fermeture_ens ens = List.fold_right ajoute_fermeture ens.lments vide;;

let dplacements liste_tats =
  let t = Array.make 256 vide in
  List.iter
    (function tat ->
      List.iter
        (function (car, dest) ->
          let i = int_of_char car in t.(i) <- ajoute dest t.(i))
      tat.transitions)
    liste_tats;
  t;;

let dterminise tat_initial =
  let tats_connus = Hashtbl.create 51
  and _remplir = Stack.create () in
  let traduire ens =
    try Hashtbl.find tats_connus ens.contenu
    with Not_found ->
      let nouvel_tat =
        { dterminal = List.exists (function n -> n.terminal) ens.lments;
          dtransitions = Array.make 256 Rejet } in
      Hashtbl.add tats_connus ens.contenu nouvel_tat;
      Stack.push (ens.lments, nouvel_tat) _remplir;
      nouvel_tat in
  let nouvel_tat_initial =
    traduire (fermeture tat_initial) in
  begin try
    while true do
      let (liste, nouvel_tat) = Stack.pop _remplir in
      let dpl = dplacements liste in
      for i = 0 to 255 do
        if not (est_vide dpl.(i)) then
          nouvel_tat.dtransitions.(i) <-
            Vers(traduire (fermeture_ens dpl.(i)))
      done
    done
  with Stack.Empty -> ()
  end;
  nouvel_tat_initial;;
