// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AppCont_FunctionTool_HeaderFile
#define _AppCont_FunctionTool_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class AppCont_Function;
class TColgp_Array1OfPnt;
class TColgp_Array1OfVec;
class TColgp_Array1OfPnt2d;
class TColgp_Array1OfVec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class AppCont_FunctionTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! returns the first parameter of the Function. <br>
Standard_EXPORT static  Standard_Real FirstParameter(const AppCont_Function& C) ;

//! returns the last parameter of the Function. <br>
Standard_EXPORT static  Standard_Real LastParameter(const AppCont_Function& C) ;

//! Returns 0. <br>
Standard_EXPORT static  Standard_Integer NbP2d(const AppCont_Function& C) ;

//! Returns 1. (the approximation will be done only for one <br>
//!          function. <br>
Standard_EXPORT static  Standard_Integer NbP3d(const AppCont_Function& C) ;

//! <tabP> is an array of only 1 element, the point value at <br>
//!          the parameter <U>. <br>
Standard_EXPORT static  void Value(const AppCont_Function& C,const Standard_Real U,TColgp_Array1OfPnt& tabPt) ;

//! <tabV> is an array of only 1 element, the derivative <br>
//!          value at the parameter <U>. <br>
Standard_EXPORT static  Standard_Boolean D1(const AppCont_Function& C,const Standard_Real U,TColgp_Array1OfVec& tabV) ;


Standard_EXPORT static  void Value(const AppCont_Function& C,const Standard_Real U,TColgp_Array1OfPnt2d& tabPt2d) ;


Standard_EXPORT static  void Value(const AppCont_Function& C,const Standard_Real U,TColgp_Array1OfPnt& tabPt,TColgp_Array1OfPnt2d& tabPt2d) ;


Standard_EXPORT static  Standard_Boolean D1(const AppCont_Function& C,const Standard_Real U,TColgp_Array1OfVec2d& tabV2d) ;


Standard_EXPORT static  Standard_Boolean D1(const AppCont_Function& C,const Standard_Real U,TColgp_Array1OfVec& tabV,TColgp_Array1OfVec2d& tabV2d) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
