// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Approx_CurvilinearParameter_HeaderFile
#define _Approx_CurvilinearParameter_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Handle_Adaptor2d_HCurve2d_HeaderFile
#include <Handle_Adaptor2d_HCurve2d.hxx>
#endif
#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Geom_BSplineCurve;
class Geom2d_BSplineCurve;
class Standard_OutOfRange;
class Standard_ConstructionError;
class Adaptor3d_HCurve;
class Adaptor2d_HCurve2d;
class Adaptor3d_HSurface;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Approximation of a Curve to make its parameter be its <br>
//!          curvilinear  abscissa <br>
//!          If the curve is a curve on a surface S, C2D is the corresponding Pcurve, <br>
//!          we considere the curve is given by its representation S(C2D(u)) <br>
//!          If the curve is a curve on 2 surfaces S1 and S2 and C2D1 C2D2 are <br>
//!          the two corresponding Pcurve, we considere the curve is given <br>
//!          by its representation  1/2(S1(C2D1(u) + S2 (C2D2(u))) <br>
class Approx_CurvilinearParameter  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! case of a free 3D curve <br>
Standard_EXPORT Approx_CurvilinearParameter(const Handle(Adaptor3d_HCurve)& C3D,const Standard_Real Tol,const GeomAbs_Shape Order,const Standard_Integer MaxDegree,const Standard_Integer MaxSegments);

//! case of a curve on one surface <br>
Standard_EXPORT Approx_CurvilinearParameter(const Handle(Adaptor2d_HCurve2d)& C2D,const Handle(Adaptor3d_HSurface)& Surf,const Standard_Real Tol,const GeomAbs_Shape Order,const Standard_Integer MaxDegree,const Standard_Integer MaxSegments);

//! case of a curve on two surfaces <br>
//! <br>
Standard_EXPORT Approx_CurvilinearParameter(const Handle(Adaptor2d_HCurve2d)& C2D1,const Handle(Adaptor3d_HSurface)& Surf1,const Handle(Adaptor2d_HCurve2d)& C2D2,const Handle(Adaptor3d_HSurface)& Surf2,const Standard_Real Tol,const GeomAbs_Shape Order,const Standard_Integer MaxDegree,const Standard_Integer MaxSegments);


Standard_EXPORT   Standard_Boolean IsDone() const;


Standard_EXPORT   Standard_Boolean HasResult() const;

//! returns the Bspline curve corresponding to the reparametrized 3D curve <br>
Standard_EXPORT   Handle_Geom_BSplineCurve Curve3d() const;

//! returns the maximum error on the reparametrized 3D curve <br>
Standard_EXPORT   Standard_Real MaxError3d() const;

//! returns the BsplineCurve representing the reparametrized 2D curve on the <br>
//!          first surface (case of a curve on one or two surfaces) <br>
Standard_EXPORT   Handle_Geom2d_BSplineCurve Curve2d1() const;

//! returns the maximum error on the first reparametrized 2D curve <br>
Standard_EXPORT   Standard_Real MaxError2d1() const;

//! returns the BsplineCurve representing the reparametrized 2D curve on the <br>
//!          second surface (case of a curve on two surfaces) <br>
Standard_EXPORT   Handle_Geom2d_BSplineCurve Curve2d2() const;

//! returns the maximum error on the second reparametrized 2D curve <br>
Standard_EXPORT   Standard_Real MaxError2d2() const;

//! print the maximum errors(s) <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT static  void ToleranceComputation(const Handle(Adaptor2d_HCurve2d)& C2D,const Handle(Adaptor3d_HSurface)& S,const Standard_Integer MaxNumber,const Standard_Real Tol,Standard_Real& TolV,Standard_Real& TolW) ;


 // Fields PRIVATE
 //
Standard_Integer myCase;
Standard_Boolean myDone;
Standard_Boolean myHasResult;
Handle_Geom_BSplineCurve myCurve3d;
Standard_Real myMaxError3d;
Handle_Geom2d_BSplineCurve myCurve2d1;
Standard_Real myMaxError2d1;
Handle_Geom2d_BSplineCurve myCurve2d2;
Standard_Real myMaxError2d2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
