// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_StateFiller_HeaderFile
#define _BOPTools_StateFiller_HeaderFile

#ifndef _BOPTools_PPaveFiller_HeaderFile
#include <BOPTools_PPaveFiller.hxx>
#endif
#ifndef _BooleanOperations_PShapesDataStructure_HeaderFile
#include <BooleanOperations_PShapesDataStructure.hxx>
#endif
#ifndef _BOPTools_PInterferencePool_HeaderFile
#include <BOPTools_PInterferencePool.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BooleanOperations_StateOfShape_HeaderFile
#include <BooleanOperations_StateOfShape.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class BOPTools_PaveFiller;
class TopoDS_Edge;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  root class to compute states (3D) <br>
class BOPTools_StateFiller  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Constructor <br>
Standard_EXPORT BOPTools_StateFiller(const BOPTools_PaveFiller& aFiller);


//! Launch the Filler <br>
Standard_EXPORT virtual  void Do() ;


//! Returns true if Ok <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Convert conventional states to VDS-states <br>
Standard_EXPORT static  BooleanOperations_StateOfShape ConvertState(const TopAbs_State aSt) ;


//! Convert VDS-states to conventional states <br>
Standard_EXPORT static  TopAbs_State ConvertState(const BooleanOperations_StateOfShape aSt) ;


//! Computation the 3D-state of the edge <anEdge> <br>
//! to solid  <aRef> <br>
Standard_EXPORT   TopAbs_State ClassifyEdgeToSolidByOnePoint(const TopoDS_Edge& anEdge,const TopoDS_Shape& aRef) ;


//! Computation the 3D-state of the shape <aShape> <br>
//! to solid <aRef> <br>
Standard_EXPORT   BooleanOperations_StateOfShape ClassifyShapeByRef(const TopoDS_Shape& aShape,const TopoDS_Shape& aRef) ;


//! Returns first subtype of <Shape> <br>
Standard_EXPORT static  TopAbs_ShapeEnum SubType(const TopoDS_Shape& aShape) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
BOPTools_PPaveFiller myFiller;
BooleanOperations_PShapesDataStructure myDS;
BOPTools_PInterferencePool myIntrPool;
Standard_Boolean myIsDone;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
