// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgoAPI_Cut_HeaderFile
#define _BRepAlgoAPI_Cut_HeaderFile

#ifndef _BRepAlgoAPI_BooleanOperation_HeaderFile
#include <BRepAlgoAPI_BooleanOperation.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;
class BOPTools_DSFiller;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! File:	BRepAlgoAPI_Cut.cdl <br>
//! Created:	Thu Oct 14 18:27:02 1993 <br>
//! Author:	Remi LEQUETTE <br>
//!		<rle@phylox> <br>//!  The class Cut provides a Boolean <br>
//! cut operation on a pair of arguments (Boolean Subtraction). <br>
//! The class Cut provides a framework for: <br>
//!         Defining the construction of a cut shape <br>
//!         Implementing the building algorithm <br>
//!         Consulting the result <br>
class BRepAlgoAPI_Cut  : public BRepAlgoAPI_BooleanOperation {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Shape aS2 cuts shape aS1. The <br>
//! resulting shape is a new shape produced by the cut operation. <br>
Standard_EXPORT BRepAlgoAPI_Cut(const TopoDS_Shape& S1,const TopoDS_Shape& S2);

//! Constructs a new shape cut from <br>
//! shape aS1 by shape aS2 using aDSFiller (see <br>
//! BRepAlgoAPI_BooleanOperation Constructor). <br>
Standard_EXPORT BRepAlgoAPI_Cut(const TopoDS_Shape& S1,const TopoDS_Shape& S2,const BOPTools_DSFiller& aDSF,const Standard_Boolean bFWD = Standard_True);





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
