// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFill_CompatibleWires_HeaderFile
#define _BRepFill_CompatibleWires_HeaderFile

#ifndef _TopTools_SequenceOfShape_HeaderFile
#include <TopTools_SequenceOfShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
class Standard_ConstructionError;
class Standard_NoSuchObject;
class TopTools_SequenceOfShape;
class TopTools_ListOfShape;
class TopoDS_Edge;
class TopTools_DataMapOfShapeListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Constructs a sequence of Wires agreed each other <br>
//!          so that the surface passing through these sections <br>
//!           is not twisted <br>
class BRepFill_CompatibleWires  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepFill_CompatibleWires();


Standard_EXPORT BRepFill_CompatibleWires(const TopTools_SequenceOfShape& Sections);


Standard_EXPORT   void Init(const TopTools_SequenceOfShape& Sections) ;


Standard_EXPORT   void SetPercent(const Standard_Real percent = 0.01) ;

//! Performs  CompatibleWires According  to  the orientation <br>
//!          and the origin of  each other <br>
Standard_EXPORT   void Perform(const Standard_Boolean WithRotation = Standard_True) ;


Standard_EXPORT   Standard_Boolean IsDone() const;

//! returns the generated sequence. <br>
Standard_EXPORT  const TopTools_SequenceOfShape& Shape() const;

//! Returns   the  shapes  created  from   a  subshape <br>
//!          <SubSection> of a section. <br>
//! <br>
Standard_EXPORT  const TopTools_ListOfShape& GeneratedShapes(const TopoDS_Edge& SubSection) const;


Standard_EXPORT  const TopTools_DataMapOfShapeListOfShape& Generated() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//!  Insert cutting  points  on  closed wires to  have same <br>
//!          number of edges. The sequence of shapes must <br>
//!          be a sequence of wires. <br>
Standard_EXPORT   void SameNumberByPolarMethod(const Standard_Boolean WithRotation = Standard_True) ;

//!  Insert cutting  points  on  open wires to  have same <br>
//!          number of edges. The sequence of shapes must <br>
//!          be a sequence of wires. <br>
Standard_EXPORT   void SameNumberByACR(const Standard_Boolean report) ;

//!  Computes  origins and orientation  on closed wires to <br>
//!          avoid twisted results. The sequence of shapes must <br>
//!          be a sequence of wires. <polar> must be true <br>
//!          if SameNumberByPolarMethod was used before. <br>
Standard_EXPORT   void ComputeOrigin(const Standard_Boolean polar) ;

//!  Computes  origins and orientation  on open wires to <br>
//!          avoid twisted results. The sequence of shapes must <br>
//!          be a sequence of wires. <br>
Standard_EXPORT   void SearchOrigin() ;


 // Fields PRIVATE
 //
TopTools_SequenceOfShape myInit;
TopTools_SequenceOfShape myWork;
Standard_Real myPercent;
Standard_Boolean myDegen1;
Standard_Boolean myDegen2;
Standard_Boolean myIsDone;
TopTools_DataMapOfShapeListOfShape myMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
