// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFill_LocationLaw_HeaderFile
#define _BRepFill_LocationLaw_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_BRepFill_LocationLaw_HeaderFile
#include <Handle_BRepFill_LocationLaw.hxx>
#endif

#ifndef _TopoDS_Wire_HeaderFile
#include <TopoDS_Wire.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_GeomFill_HArray1OfLocationLaw_HeaderFile
#include <Handle_GeomFill_HArray1OfLocationLaw.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TopTools_HArray1OfShape_HeaderFile
#include <Handle_TopTools_HArray1OfShape.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _GeomFill_PipeError_HeaderFile
#include <GeomFill_PipeError.hxx>
#endif
#ifndef _Handle_GeomFill_LocationLaw_HeaderFile
#include <Handle_GeomFill_LocationLaw.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class GeomFill_HArray1OfLocationLaw;
class TColStd_HArray1OfReal;
class TopTools_HArray1OfShape;
class TColStd_HArray1OfInteger;
class Standard_OutOfRange;
class TopoDS_Wire;
class TColStd_Array1OfInteger;
class GeomFill_LocationLaw;
class TopoDS_Edge;
class TopoDS_Vertex;
class TopoDS_Shape;


//! Location Law on a  Wire. <br>
class BRepFill_LocationLaw : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Return a error status, if the  status is not PipeOk then <br>
//!          it exist a parameter tlike the law is not valuable for t. <br>
Standard_EXPORT   GeomFill_PipeError GetStatus() const;

//!  Apply a linear   transformation  on each law, to  have <br>
//!          continuity of the global law beetween the edges. <br>
Standard_EXPORT virtual  void TransformInG0Law() ;

//! Apply a linear transformation on each law, to reduce <br>
//!           the   dicontinuities  of law at one  rotation. <br>
Standard_EXPORT virtual  void TransformInCompatibleLaw(const Standard_Real AngularTolerance) ;


Standard_EXPORT   void DeleteTransform() ;


Standard_EXPORT   Standard_Integer NbHoles(const Standard_Real Tol = 1.0e-7) ;


Standard_EXPORT   void Holes(TColStd_Array1OfInteger& Interval) const;

//! Return the number of elementary Law <br>
Standard_EXPORT   Standard_Integer NbLaw() const;

//! Return the elementary Law of rank <Index> <br>
//!          <Index> have to be in [1, NbLaw()] <br>
Standard_EXPORT  const Handle_GeomFill_LocationLaw& Law(const Standard_Integer Index) const;

//! return the path <br>
Standard_EXPORT  const TopoDS_Wire& Wire() const;

//! Return the Edge of rank <Index> in the path <br>
//!          <Index> have to be in [1, NbLaw()] <br>
Standard_EXPORT  const TopoDS_Edge& Edge(const Standard_Integer Index) const;

//! Return the vertex of rank <Index> in the path <br>
//!          <Index> have to be in [0, NbLaw()] <br>
Standard_EXPORT   TopoDS_Vertex Vertex(const Standard_Integer Index) const;

//! Compute <OutputVertex> like a transformation of <br>
//!          <InputVertex>  the  transformation   is given by <br>
//!          evaluation of the location law   in the vertex of <br>
//!          rank   <Index>. <br>
//!          <Location> is used to manage discontinuities : <br>
//!   - -1 : The law before the vertex is used. <br>
//!   -  1 : The law after the vertex is used. <br>
//!   -  0 : Average of the both laws is used. <br>
Standard_EXPORT   void PerformVertex(const Standard_Integer Index,const TopoDS_Vertex& InputVertex,const Standard_Real TolMin,TopoDS_Vertex& OutputVertex,const Standard_Integer Location = 0) const;

//!Return the Curvilinear Bounds of the <Index> Law <br>
Standard_EXPORT   void CurvilinearBounds(const Standard_Integer Index,Standard_Real& First,Standard_Real& Last) const;


Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Compute the Law's continuity beetween 2 edges of the path <br>
//! The result can be : <br>
//!  -1 : Case Not connex <br>
//!  0  : It is connex (G0) <br>
//!  1  : It is tangent (G1) <br>
Standard_EXPORT   Standard_Integer IsG1(const Standard_Integer Index,const Standard_Real SpatialTolerance = 1.0e-7,const Standard_Real AngularTolerance = 1.0e-4) const;

//! Apply the Law to a shape, for a given Curnilinear abscissa <br>
Standard_EXPORT   void D0(const Standard_Real Abscissa,TopoDS_Shape& Section) ;

//! Find the  index Law  and the  parmaeter, for  a given <br>
//!          Curnilinear abscissa <br>
Standard_EXPORT   void Parameter(const Standard_Real Abscissa,Standard_Integer& Index,Standard_Real& Param) ;

//!Return the curvilinear abscissa  corresponding to a point <br>
//!                 of  the path, defined by  <Index>  of  Edge and a <br>
//!                parameter on the edge. <br>
Standard_EXPORT   Standard_Real Abscissa(const Standard_Integer Index,const Standard_Real Param) ;
//Standard_EXPORT ~BRepFill_LocationLaw();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Initialize all the fields, this methode have to <br>
//!          be called by the constructors of Inherited class. <br>
Standard_EXPORT   void Init(const TopoDS_Wire& Path) ;

//! To preseve if possible  the Tangent in transformations <br>
//! It is the default mode. <br>
Standard_EXPORT   void TangentIsMain() ;

//! To preseve if possible the Normal in transformations <br>
Standard_EXPORT   void NormalIsMain() ;

//! To preseve if possible the BiNormal in transformations <br>
Standard_EXPORT   void BiNormalIsMain() ;


 // Fields PROTECTED
 //
TopoDS_Wire myPath;
Standard_Real myTol;
Handle_GeomFill_HArray1OfLocationLaw myLaws;
Handle_TColStd_HArray1OfReal myLength;
Handle_TopTools_HArray1OfShape myEdges;
Handle_TColStd_HArray1OfInteger myDisc;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myType;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
