// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Convert_ParabolaToBSplineCurve_HeaderFile
#define _Convert_ParabolaToBSplineCurve_HeaderFile

#ifndef _Convert_ConicToBSplineCurve_HeaderFile
#include <Convert_ConicToBSplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Parab2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  This algorithm converts a parabola into a non rational B-spline <br>
//!  curve. <br>
//!  The parabola is a Parab2d from package gp with the parametrization <br>
//!  P (U) = Loc + F * (U*U * Xdir + 2 * U * Ydir) where Loc is the <br>
//!  apex of the parabola, Xdir is the normalized direction of the <br>
//!  symmetry axis of the parabola, Ydir is the normalized direction of <br>
//!  the directrix and F is the focal length. <br>
//! KeyWords : <br>
//!  Convert, Parabola, BSplineCurve, 2D . <br>
class Convert_ParabolaToBSplineCurve  : public Convert_ConicToBSplineCurve {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  The parabola Prb is limited between the parametric values U1, U2 <br>
//!  and the equivalent B-spline curve as the same orientation as the <br>
//!  parabola Prb. <br>
Standard_EXPORT Convert_ParabolaToBSplineCurve(const gp_Parab2d& Prb,const Standard_Real U1,const Standard_Real U2);





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
